/*
 * Decompiled with CFR 0.152.
 */
package dev.jsinco.brewery.api.event;

import com.google.common.base.Preconditions;
import dev.jsinco.brewery.api.event.CustomEvent;
import dev.jsinco.brewery.api.util.BreweryKey;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CustomEventRegistry {
    Map<BreweryKey, CustomEvent.Keyed> customEvents = new HashMap<BreweryKey, CustomEvent.Keyed>();

    public static Builder builder() {
        return new Builder();
    }

    public void registerCustomEvent(CustomEvent.Keyed customEvent) {
        Preconditions.checkNotNull((Object)customEvent);
        this.customEvents.put(customEvent.key(), customEvent);
    }

    @Nullable
    public CustomEvent.Keyed getCustomEvent(BreweryKey key) {
        Preconditions.checkNotNull((Object)key);
        return this.customEvents.get(key);
    }

    public Collection<CustomEvent.Keyed> events() {
        return this.customEvents.values();
    }

    public void clear() {
        this.customEvents.clear();
    }

    public static class Builder {
        List<CustomEvent.Keyed> customEvents = new ArrayList<CustomEvent.Keyed>();

        public Builder addEvent(@NotNull CustomEvent.Keyed event) {
            Preconditions.checkNotNull((Object)event);
            this.customEvents.add(event);
            return this;
        }

        public CustomEventRegistry build() {
            CustomEventRegistry output = new CustomEventRegistry();
            this.customEvents.forEach(output::registerCustomEvent);
            return output;
        }
    }
}

