/*
 * Decompiled with CFR 0.152.
 */
package dev.jsinco.brewery.recipes;

import com.google.common.base.Preconditions;
import dev.jsinco.brewery.api.brew.BrewingStep;
import dev.jsinco.brewery.api.ingredient.BaseIngredient;
import dev.jsinco.brewery.api.ingredient.Ingredient;
import dev.jsinco.brewery.api.ingredient.IngredientGroup;
import dev.jsinco.brewery.api.recipe.DefaultRecipe;
import dev.jsinco.brewery.api.recipe.Recipe;
import dev.jsinco.brewery.api.recipe.RecipeRegistry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;

public class RecipeRegistryImpl<I>
implements RecipeRegistry<I> {
    private Map<String, Recipe<I>> recipes = new ConcurrentHashMap<String, Recipe<I>>();
    private Map<String, DefaultRecipe<I>> defaultRecipes = new HashMap<String, DefaultRecipe<I>>();
    private List<DefaultRecipe<I>> defaultRecipeList = new ArrayList<DefaultRecipe<I>>();
    private Set<BaseIngredient> allIngredients = Collections.newSetFromMap(new ConcurrentHashMap());

    public void registerRecipes(@NotNull Map<String, Recipe<I>> recipes) {
        this.recipes = new ConcurrentHashMap<String, Recipe<I>>(recipes);
        recipes.values().stream().map(this::getRecipeIngredients).flatMap(Collection::stream).forEach(this.allIngredients::add);
    }

    @Override
    public Optional<Recipe<I>> getRecipe(@NotNull String recipeName) {
        Preconditions.checkNotNull((Object)recipeName);
        Recipe<I> recipe = this.recipes.get(recipeName);
        if (recipe != null) {
            return Optional.of(recipe);
        }
        for (Map.Entry<String, Recipe<I>> entry : this.recipes.entrySet()) {
            if (!entry.getKey().equalsIgnoreCase(recipeName)) continue;
            return Optional.of(entry.getValue());
        }
        return Optional.empty();
    }

    @Override
    public Collection<Recipe<I>> getRecipes() {
        return this.recipes.values();
    }

    @Override
    public void registerRecipe(Recipe<I> recipe) {
        this.recipes.put(recipe.getRecipeName(), recipe);
        this.allIngredients.addAll(this.getRecipeIngredients(recipe));
    }

    @Override
    public void unRegisterRecipe(Recipe<I> recipe) {
        this.recipes.remove(recipe.getRecipeName());
        this.allIngredients = this.recipes.values().stream().map(this::getRecipeIngredients).flatMap(Collection::stream).collect(Collectors.toSet());
    }

    @Override
    public Optional<DefaultRecipe<I>> getDefaultRecipe(@NotNull String recipeName) {
        Preconditions.checkNotNull((Object)recipeName);
        return Optional.ofNullable(this.defaultRecipes.get(recipeName));
    }

    private List<BaseIngredient> getRecipeIngredients(Recipe<?> recipe) {
        return recipe.getSteps().stream().filter(BrewingStep.IngredientsStep.class::isInstance).map(BrewingStep.IngredientsStep.class::cast).map(BrewingStep.IngredientsStep::ingredients).map(Map::keySet).flatMap(Collection::stream).flatMap(ingredient -> {
            if (ingredient instanceof IngredientGroup) {
                IngredientGroup ingredientGroup = (IngredientGroup)ingredient;
                return ingredientGroup.alternatives().stream().map(Ingredient::toBaseIngredient);
            }
            return Stream.of(ingredient.toBaseIngredient());
        }).toList();
    }

    @Override
    public Collection<DefaultRecipe<I>> getDefaultRecipes() {
        return this.defaultRecipeList;
    }

    @Override
    public void registerDefaultRecipe(String name, DefaultRecipe<I> recipe) {
        this.defaultRecipes.put(name, recipe);
        this.defaultRecipeList.add(recipe);
    }

    @Override
    public void unRegisterDefaultRecipe(String name) {
        DefaultRecipe<I> defaultRecipe = this.defaultRecipes.remove(name);
        if (defaultRecipe == null) {
            return;
        }
        this.defaultRecipeList.remove(defaultRecipe);
    }

    @Override
    public boolean isRegisteredIngredient(Ingredient ingredient) {
        return ingredient.findMatch(this.allIngredients).isPresent();
    }

    @Override
    public Set<BaseIngredient> registeredIngredients() {
        return this.allIngredients;
    }

    public void clear() {
        this.recipes.clear();
        this.defaultRecipes.clear();
        this.defaultRecipeList.clear();
        this.allIngredients.clear();
    }
}

