/*
 * Decompiled with CFR 0.152.
 */
package dev.jsinco.brewery.recipes;

import dev.jsinco.brewery.api.brew.Brew;
import dev.jsinco.brewery.api.brew.BrewQuality;
import dev.jsinco.brewery.api.brew.BrewScore;
import dev.jsinco.brewery.api.brew.BrewingStep;
import dev.jsinco.brewery.api.brew.PartialBrewScore;
import dev.jsinco.brewery.api.brew.ScoreType;
import dev.jsinco.brewery.util.MessageUtil;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import net.kyori.adventure.text.minimessage.translation.Argument;
import org.jetbrains.annotations.Nullable;

public class BrewScoreImpl
implements BrewScore {
    public static final BrewScoreImpl PLACEHOLDER = new BrewScoreImpl(1.0);
    private BrewQuality qualityOverride;
    private final List<Map<ScoreType, PartialBrewScore>> scores;
    private final boolean completed;
    private final double brewDifficulty;

    public BrewScoreImpl(double score) {
        this.scores = List.of(Map.of(ScoreType.TIME, new PartialBrewScore(score, ScoreType.TIME)));
        this.completed = true;
        this.brewDifficulty = 1.0;
    }

    public static BrewScoreImpl failed(Brew brew) {
        List<Map<ScoreType, PartialBrewScore>> scores = brew.getCompletedSteps().stream().map(BrewingStep::failedScores).toList();
        return new BrewScoreImpl(scores, true, 1.0);
    }

    @Override
    @Nullable
    public BrewQuality brewQuality() {
        if (this.hasQualityOverride()) {
            return this.qualityOverride;
        }
        return BrewScoreImpl.quality(this.score());
    }

    public BrewScoreImpl(List<Map<ScoreType, PartialBrewScore>> scores, boolean completed, double brewDifficulty) {
        this.scores = scores;
        this.completed = completed;
        this.brewDifficulty = brewDifficulty / 2.0;
    }

    @Override
    public Map<ScoreType, PartialBrewScore> getPartialScores(int stepIndex) {
        return this.scores.get(stepIndex);
    }

    @Override
    public double score() {
        if (this.hasQualityOverride()) {
            return switch (this.qualityOverride) {
                default -> throw new MatchException(null, null);
                case BrewQuality.EXCELLENT -> 1.0;
                case BrewQuality.GOOD -> 0.65;
                case BrewQuality.BAD -> 0.01;
            };
        }
        return BrewScoreImpl.applyDifficulty(this.rawScore(), this.brewDifficulty);
    }

    public static double applyDifficulty(double score, double brewDifficulty) {
        score = Math.min(score + 0.05, 1.0);
        if (brewDifficulty <= 0.0) {
            return 1.0;
        }
        double scoreWithDifficulty = brewDifficulty == 1.0 ? score : (Math.pow(brewDifficulty, 3.0 * score) - 1.0) / (Math.pow(brewDifficulty, 3.0) - 1.0);
        return Math.max(scoreWithDifficulty - 0.3, 0.0) * 1.0 / 0.7;
    }

    @Override
    public Component displayName() {
        return Component.translatable((String)"tbp.brew.tooltip.quality-display", (ComponentLike[])new ComponentLike[]{Argument.tagResolver((TagResolver)MessageUtil.getValueDisplayTagResolver(this.score() * 100.0))});
    }

    @Override
    public double rawScore() {
        return this.scores.stream().map(Map::values).map(this::rawPartialScore).reduce(1.0, (aDouble, aDouble2) -> aDouble * aDouble2);
    }

    private double rawPartialScore(Collection<PartialBrewScore> partialBrewScores) {
        return partialBrewScores.stream().map(PartialBrewScore::score).map(score -> partialBrewScores.size() == 1 ? score : Math.sqrt(score)).reduce(1.0, (value1, value2) -> value1 * value2);
    }

    @Override
    public boolean completed() {
        return this.completed;
    }

    @Override
    public double brewDifficulty() {
        return this.brewDifficulty;
    }

    public static BrewQuality quality(double score) {
        if (score >= 0.8) {
            return BrewQuality.EXCELLENT;
        }
        if (score >= 0.6) {
            return BrewQuality.GOOD;
        }
        if (score > 0.0) {
            return BrewQuality.BAD;
        }
        return null;
    }

    public boolean hasQualityOverride() {
        return this.qualityOverride != null;
    }

    @Generated
    public BrewQuality getQualityOverride() {
        return this.qualityOverride;
    }

    @Generated
    public void setQualityOverride(BrewQuality qualityOverride) {
        this.qualityOverride = qualityOverride;
    }
}

