/*
 * Decompiled with CFR 0.152.
 */
package dev.jsinco.brewery.lib.eu.okaeri.configs.json.gson;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import dev.jsinco.brewery.lib.eu.okaeri.configs.configurer.Configurer;
import dev.jsinco.brewery.lib.eu.okaeri.configs.postprocessor.ConfigPostprocessor;
import dev.jsinco.brewery.lib.eu.okaeri.configs.schema.ConfigDeclaration;
import dev.jsinco.brewery.lib.eu.okaeri.configs.schema.FieldDeclaration;
import dev.jsinco.brewery.lib.eu.okaeri.configs.schema.GenericsDeclaration;
import dev.jsinco.brewery.lib.eu.okaeri.configs.serdes.SerdesContext;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import lombok.NonNull;

public class JsonGsonConfigurer
extends Configurer {
    private Map<String, Object> map;
    private Gson gson;

    public JsonGsonConfigurer() {
        this.gson = new GsonBuilder().disableHtmlEscaping().setPrettyPrinting().create();
        this.map = new LinkedHashMap<String, Object>();
    }

    public JsonGsonConfigurer(@NonNull Gson gson) {
        this(gson, new LinkedHashMap<String, Object>());
        if (gson == null) {
            throw new NullPointerException("gson is marked non-null but is null");
        }
    }

    public JsonGsonConfigurer(@NonNull Gson gson, @NonNull Map<String, Object> map) {
        if (gson == null) {
            throw new NullPointerException("gson is marked non-null but is null");
        }
        if (map == null) {
            throw new NullPointerException("map is marked non-null but is null");
        }
        this.gson = gson;
        this.map = map;
    }

    @Override
    public List<String> getExtensions() {
        return Collections.singletonList("json");
    }

    @Override
    public void setValue(@NonNull String key, Object value, GenericsDeclaration type, FieldDeclaration field) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        Object simplified = this.simplify(value, type, SerdesContext.of(this, field), true);
        this.map.put(key, simplified);
    }

    @Override
    public void setValueUnsafe(@NonNull String key, Object value) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        this.map.put(key, value);
    }

    @Override
    public Object getValue(@NonNull String key) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        return this.map.get(key);
    }

    @Override
    public Object remove(@NonNull String key) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        return this.map.remove(key);
    }

    @Override
    public boolean keyExists(@NonNull String key) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        return this.map.containsKey(key);
    }

    @Override
    public List<String> getAllKeys() {
        return Collections.unmodifiableList(new ArrayList<String>(this.map.keySet()));
    }

    @Override
    public void load(@NonNull InputStream inputStream, @NonNull ConfigDeclaration declaration) throws Exception {
        if (inputStream == null) {
            throw new NullPointerException("inputStream is marked non-null but is null");
        }
        if (declaration == null) {
            throw new NullPointerException("declaration is marked non-null but is null");
        }
        String data = ConfigPostprocessor.of(inputStream).getContext();
        this.map = this.gson.fromJson(data, Map.class);
        if (this.map != null) {
            return;
        }
        this.map = new LinkedHashMap<String, Object>();
    }

    @Override
    public void write(@NonNull OutputStream outputStream, @NonNull ConfigDeclaration declaration) throws Exception {
        if (outputStream == null) {
            throw new NullPointerException("outputStream is marked non-null but is null");
        }
        if (declaration == null) {
            throw new NullPointerException("declaration is marked non-null but is null");
        }
        OutputStreamWriter writer = new OutputStreamWriter(outputStream, StandardCharsets.UTF_8);
        this.gson.toJson(this.map, (Appendable)writer);
        writer.flush();
    }
}

