/*
 * Decompiled with CFR 0.152.
 */
package dev.jsinco.brewery.ingredient;

import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import dev.jsinco.brewery.api.ingredient.Ingredient;
import dev.jsinco.brewery.api.ingredient.IngredientManager;
import dev.jsinco.brewery.api.util.Pair;
import dev.jsinco.brewery.util.FutureUtil;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;

public class IngredientUtil {
    private IngredientUtil() {
        throw new IllegalStateException("Utility class");
    }

    public static CompletableFuture<Map<Ingredient, Integer>> ingredientsFromJson(JsonObject json, IngredientManager<?> ingredientManager) {
        List ingredientsFuture = json.entrySet().stream().map(jsonEntry -> ingredientManager.deserializeIngredient((String)jsonEntry.getKey()).thenApplyAsync(optionalIngredient -> optionalIngredient.map(ingredient -> new Pair<Ingredient, Integer>((Ingredient)ingredient, ((JsonElement)jsonEntry.getValue()).getAsInt())).orElseThrow(() -> new IllegalArgumentException((String)jsonEntry.getKey() + " is not a valid ingredient")))).toList();
        return FutureUtil.mergeFutures(ingredientsFuture).thenApplyAsync(ingredientPairs -> {
            ImmutableMap.Builder output = new ImmutableMap.Builder();
            ingredientPairs.forEach(ingredientPair -> output.put((Object)((Ingredient)ingredientPair.first()), (Object)((Integer)ingredientPair.second())));
            return output.build();
        });
    }

    public static JsonObject ingredientsToJson(Map<Ingredient, Integer> ingredients, IngredientManager<?> ingredientManager) {
        JsonObject output = new JsonObject();
        for (Map.Entry<Ingredient, Integer> entry : ingredients.entrySet()) {
            output.add(ingredientManager.serializeIngredient(entry.getKey()), new JsonPrimitive(entry.getValue()));
        }
        return output;
    }
}

