/*
 * Decompiled with CFR 0.152.
 */
package dev.jsinco.brewery.effect;

import com.google.common.collect.ImmutableList;
import dev.jsinco.brewery.api.effect.DrunkState;
import dev.jsinco.brewery.api.effect.DrunksManager;
import dev.jsinco.brewery.api.effect.ModifierConsume;
import dev.jsinco.brewery.api.effect.modifier.DrunkenModifier;
import dev.jsinco.brewery.api.event.CustomEventRegistry;
import dev.jsinco.brewery.api.event.DrunkEvent;
import dev.jsinco.brewery.api.event.EventData;
import dev.jsinco.brewery.api.event.EventProbability;
import dev.jsinco.brewery.api.event.NamedDrunkEvent;
import dev.jsinco.brewery.api.util.BreweryRegistry;
import dev.jsinco.brewery.api.util.Logger;
import dev.jsinco.brewery.api.util.Pair;
import dev.jsinco.brewery.configuration.DrunkenModifierSection;
import dev.jsinco.brewery.configuration.EventSection;
import dev.jsinco.brewery.database.PersistenceException;
import dev.jsinco.brewery.database.PersistenceHandler;
import dev.jsinco.brewery.effect.DrunkStateDataType;
import dev.jsinco.brewery.effect.DrunkStateImpl;
import dev.jsinco.brewery.effect.DrunkenModifierDataType;
import dev.jsinco.brewery.util.RandomUtil;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.LongSupplier;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DrunksManagerImpl<C>
implements DrunksManager {
    private final CustomEventRegistry eventRegistry;
    private final PersistenceHandler<C> persistenceHandler;
    private final DrunkStateDataType<C> drunkStateDataType;
    private final DrunkenModifierDataType<C> drunkenModifierDataType;
    private final Function<EventData, Optional<DrunkEvent>> eventSupplier;
    private Set<EventData> allowedEvents;
    private List<NamedDrunkEvent> namedDrunkEvents = this.initializeDrunkEventsWithOverrides();
    private Map<UUID, DrunkState> drunks = new HashMap<UUID, DrunkState>();
    private LongSupplier timeSupplier;
    private Map<Long, Map<UUID, DrunkEvent>> events = new HashMap<Long, Map<UUID, DrunkEvent>>();
    private Map<UUID, Long> plannedEvents = new HashMap<UUID, Long>();
    private static final Random RANDOM = new Random();

    public DrunksManagerImpl(CustomEventRegistry registry, Set<EventData> allowedEvents, Function<EventData, Optional<DrunkEvent>> eventSupplier, LongSupplier timeSupplier, PersistenceHandler<C> persistenceHandler, DrunkStateDataType<C> drunkStateDataType, DrunkenModifierDataType<C> drunkenModifierDataType) {
        this.eventRegistry = registry;
        this.allowedEvents = allowedEvents;
        this.timeSupplier = timeSupplier;
        this.persistenceHandler = persistenceHandler;
        this.drunkStateDataType = drunkStateDataType;
        this.drunkenModifierDataType = drunkenModifierDataType;
        this.eventSupplier = eventSupplier;
        this.loadDrunkStates();
    }

    private void loadDrunkStates() {
        try {
            this.persistenceHandler.retrieveAllNow(this.drunkStateDataType).forEach(pair -> this.drunks.put((UUID)pair.second(), (DrunkState)pair.first()));
        }
        catch (PersistenceException e) {
            Logger.logErr(e);
        }
    }

    @Override
    @Nullable
    public DrunkState consume(UUID playerUuid, String modifierName, double value) {
        return this.consume(playerUuid, new ModifierConsume(DrunkenModifierSection.modifiers().modifier(modifierName), value));
    }

    @Override
    @Nullable
    public DrunkState consume(UUID playerUuid, List<ModifierConsume> consumptions) {
        return this.consume(playerUuid, consumptions, this.timeSupplier.getAsLong());
    }

    @Override
    @Nullable
    public DrunkState consume(UUID playerUuid, ModifierConsume modifier) {
        return this.consume(playerUuid, List.of(modifier));
    }

    @Nullable
    public DrunkState consume(UUID playerUuid, List<ModifierConsume> modifiers, long timestamp) {
        DrunkState initialState;
        boolean alreadyDrunk = this.drunks.containsKey(playerUuid);
        DrunkState newState = initialState = alreadyDrunk ? this.drunks.get(playerUuid).recalculate(timestamp) : new DrunkStateImpl(timestamp, -1L, DrunkenModifierSection.modifiers().drunkenModifiers().stream().collect(Collectors.toUnmodifiableMap(temp -> temp, DrunkenModifier::minValue)));
        ArrayList<ModifierConsume> sortedModifiers = new ArrayList<ModifierConsume>(modifiers);
        sortedModifiers.sort(Comparator.comparing(modifierConsume -> modifierConsume.modifier().name(), String::compareTo));
        for (ModifierConsume modifierConsume2 : sortedModifiers) {
            if (modifierConsume2.cascade()) {
                Pair<DrunkState, Boolean> drunkStateChange = newState.cascadeModifier(modifierConsume2.modifier(), modifierConsume2.value());
                newState = drunkStateChange.first();
                if (drunkStateChange.second().booleanValue()) continue;
            }
            newState = newState.setModifier(modifierConsume2.modifier(), modifierConsume2.value() + newState.modifierValue(modifierConsume2.modifier()));
        }
        if (newState.additionalModifierData().isEmpty() && !this.isPassedOut(newState)) {
            this.drunks.remove(playerUuid);
            if (alreadyDrunk) {
                try {
                    this.persistenceHandler.remove(this.drunkStateDataType, playerUuid);
                }
                catch (PersistenceException e) {
                    Logger.logErr(e);
                }
            }
            return null;
        }
        this.drunks.put(playerUuid, newState);
        this.planEvent(playerUuid);
        try {
            CompletableFuture<Void> future = alreadyDrunk ? this.persistenceHandler.updateValue(this.drunkStateDataType, new Pair<DrunkState, UUID>(newState, playerUuid)) : this.persistenceHandler.insertValue(this.drunkStateDataType, new Pair<DrunkState, UUID>(newState, playerUuid));
            Set allModifiers = Stream.concat(initialState.additionalModifierData().stream(), newState.additionalModifierData().stream()).map(Pair::first).collect(Collectors.toSet());
            Map<DrunkenModifier, Double> newModifiers = newState.modifiers();
            future.thenAcceptAsync(ignored -> {
                try {
                    for (DrunkenModifier modifier : allModifiers) {
                        if (((Double)newModifiers.get(modifier)).doubleValue() != modifier.minValue()) {
                            this.persistenceHandler.insertValue(this.drunkenModifierDataType, new Pair<DrunkenModifierDataType.Data, Double>(new DrunkenModifierDataType.Data(modifier, playerUuid), (Double)newModifiers.get(modifier)));
                        }
                        if (((Double)newModifiers.get(modifier)).doubleValue() != modifier.minValue()) continue;
                        this.persistenceHandler.remove(this.drunkenModifierDataType, new DrunkenModifierDataType.Data(modifier, playerUuid));
                    }
                }
                catch (PersistenceException e) {
                    Logger.logErr(e);
                }
            });
        }
        catch (PersistenceException e) {
            Logger.logErr(e);
        }
        return newState;
    }

    @Override
    @Nullable
    public DrunkState getDrunkState(UUID playerUuid) {
        boolean alreadyDrunk = this.drunks.containsKey(playerUuid);
        return Optional.ofNullable(alreadyDrunk ? this.drunks.get(playerUuid).recalculate(this.timeSupplier.getAsLong()) : null).filter(drunkState -> !drunkState.additionalModifierData().isEmpty()).orElse(null);
    }

    @Override
    public void reset(@NotNull Set<EventData> allowedEvents) {
        this.plannedEvents.clear();
        this.drunks.clear();
        this.allowedEvents = allowedEvents;
        this.events.clear();
        this.loadDrunkStates();
        this.drunks.keySet().forEach(this::planEvent);
        this.namedDrunkEvents = this.initializeDrunkEventsWithOverrides();
    }

    private List<NamedDrunkEvent> initializeDrunkEventsWithOverrides() {
        ImmutableList.Builder output = new ImmutableList.Builder();
        for (NamedDrunkEvent namedDrunkEvent : BreweryRegistry.DRUNK_EVENT.values()) {
            EventSection.events().namedDrunkEventsOverride().stream().filter(namedDrunkEvent::equals).findAny().ifPresentOrElse(arg_0 -> ((ImmutableList.Builder)output).add(arg_0), () -> output.add((Object)namedDrunkEvent));
        }
        return output.build();
    }

    @Override
    public void clear(@NotNull UUID playerUuid) {
        Long plannedEventTime = this.plannedEvents.remove(playerUuid);
        this.drunks.remove(playerUuid);
        try {
            this.persistenceHandler.remove(this.drunkStateDataType, playerUuid);
        }
        catch (PersistenceException e) {
            Logger.logErr(e);
        }
        if (plannedEventTime == null) {
            return;
        }
        if (this.events.containsKey(plannedEventTime)) {
            this.events.get(plannedEventTime).remove(playerUuid);
        }
    }

    public void tick(BiConsumer<UUID, DrunkEvent> action, Predicate<UUID> onlinePredicate) {
        Map<UUID, DrunkEvent> currentEvents = this.events.remove(this.timeSupplier.getAsLong());
        if (currentEvents == null) {
            return;
        }
        HashSet<UUID> toRemove = new HashSet<UUID>();
        for (UUID currentEvent : currentEvents.keySet()) {
            if (this.drunks.containsKey(currentEvent)) continue;
            toRemove.add(currentEvent);
        }
        currentEvents.forEach((key, value) -> this.plannedEvents.remove(key));
        toRemove.forEach(currentEvents::remove);
        currentEvents.forEach(action);
        currentEvents.keySet().stream().filter(onlinePredicate).forEach(this::planEvent);
    }

    @Override
    public void planEvent(@NotNull UUID playerUuid) {
        DrunkState drunkState = this.getDrunkState(playerUuid);
        if (drunkState == null) {
            return;
        }
        List<Pair> drunkEvents = this.allowedEvents.stream().map(this.eventSupplier).flatMap(Optional::stream).map(drunkEvent -> new Pair<DrunkEvent, EventProbability.Calculated>((DrunkEvent)drunkEvent, drunkEvent.probability().evaluate(DrunkStateImpl.compileVariables(drunkState.modifiers(), null, 0.0)))).filter(drunkEvent -> ((EventProbability.Calculated)drunkEvent.second()).enabled()).map(drunkEvent -> new Pair<DrunkEvent, Double>((DrunkEvent)drunkEvent.first(), ((EventProbability.Calculated)drunkEvent.second()).probability())).filter(drunkEvent -> (Double)drunkEvent.second() > 0.0).toList();
        if (drunkEvents.isEmpty()) {
            return;
        }
        double cumulativeSum = drunkEvents.stream().map(Pair::second).reduce(0.0, Double::sum);
        DrunkEvent drunkEvent2 = (DrunkEvent)RandomUtil.randomWeighted(drunkEvents, Pair::second).first();
        double value = 20.0 / cumulativeSum;
        long time = (long)((double)this.timeSupplier.getAsLong() + Math.max(1.0, RANDOM.nextGaussian(value, value / 2.0)));
        if (this.plannedEvents.containsKey(playerUuid)) {
            if (this.plannedEvents.get(playerUuid) < time) {
                return;
            }
            this.events.get(this.plannedEvents.get(playerUuid)).remove(playerUuid);
        }
        this.events.computeIfAbsent(time, ignored -> new HashMap()).put(playerUuid, drunkEvent2);
        this.plannedEvents.put(playerUuid, time);
    }

    @Override
    public void registerPassedOut(@NotNull UUID playerUuid) {
        this.drunks.computeIfPresent(playerUuid, (ignored, drunkState) -> drunkState.withPassOut(this.timeSupplier.getAsLong()));
    }

    @Override
    public boolean isPassedOut(@NotNull UUID playerUUID) {
        return this.drunks.containsKey(playerUUID) && this.isPassedOut(this.drunks.get(playerUUID));
    }

    private boolean isPassedOut(DrunkState drunkState) {
        long passOutTimeStamp = drunkState.kickedTimestamp();
        if (passOutTimeStamp == -1L) {
            return false;
        }
        return passOutTimeStamp + EventSection.events().passOutTime().durationTicks() > this.timeSupplier.getAsLong();
    }

    @Override
    @Nullable
    public Pair<DrunkEvent, Long> getPlannedEvent(@NotNull UUID playerUUID) {
        Long time = this.plannedEvents.get(playerUUID);
        if (time == null) {
            return null;
        }
        return new Pair<DrunkEvent, Long>(this.events.get(time).get(playerUUID), time);
    }

    @Generated
    public LongSupplier getTimeSupplier() {
        return this.timeSupplier;
    }
}

