/*
 * Decompiled with CFR 0.152.
 */
package dev.jsinco.brewery.effect;

import com.google.common.collect.ImmutableMap;
import dev.jsinco.brewery.api.effect.DrunkState;
import dev.jsinco.brewery.api.effect.modifier.DrunkenModifier;
import dev.jsinco.brewery.api.util.Pair;
import dev.jsinco.brewery.configuration.DrunkenModifierSection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

public record DrunkStateImpl(long timestamp, long kickedTimestamp, Map<DrunkenModifier, Double> modifiers) implements DrunkState
{
    public DrunkStateImpl {
        ImmutableMap.Builder builder = new ImmutableMap.Builder();
        for (DrunkenModifier drunkenModifier : DrunkenModifierSection.modifiers().drunkenModifiers()) {
            builder.put((Object)drunkenModifier, (Object)drunkenModifier.sanitize(modifiers.getOrDefault(drunkenModifier, drunkenModifier.minValue())));
        }
        modifiers = builder.build();
    }

    public DrunkStateImpl(long timestamp, long kickedTimestamp) {
        this(timestamp, kickedTimestamp, Map.of());
    }

    @Override
    public DrunkStateImpl recalculate(long timestamp) {
        if (timestamp < this.timestamp) {
            return new DrunkStateImpl(this.timestamp, this.kickedTimestamp, this.modifiers);
        }
        Map<String, Double> variables = DrunkStateImpl.compileVariables(this.modifiers, null, 0.0);
        int diff = (int)(timestamp - this.timestamp);
        ImmutableMap.Builder newDrunkenModifiers = new ImmutableMap.Builder();
        for (Map.Entry<DrunkenModifier, Double> entry : this.modifiers.entrySet()) {
            double decrementTime = entry.getKey().decrementTime().evaluate(variables);
            double value = decrementTime == 0.0 ? 0.0 : (decrementTime == -1.0 ? entry.getValue() : entry.getValue() - (double)diff / decrementTime);
            newDrunkenModifiers.put((Object)entry.getKey(), (Object)value);
        }
        return new DrunkStateImpl(timestamp, this.kickedTimestamp, (Map<DrunkenModifier, Double>)newDrunkenModifiers.build());
    }

    @Override
    public DrunkStateImpl setModifier(DrunkenModifier modifier, double value) {
        ImmutableMap.Builder newModifiers = new ImmutableMap.Builder();
        for (Map.Entry<DrunkenModifier, Double> entry : this.modifiers.entrySet()) {
            newModifiers.put((Object)entry.getKey(), (Object)(entry.getKey().equals(modifier) ? value : entry.getValue()));
        }
        return new DrunkStateImpl(this.timestamp, this.kickedTimestamp, (Map<DrunkenModifier, Double>)newModifiers.build());
    }

    @Override
    public DrunkStateImpl withModifiers(Map<DrunkenModifier, Double> modifiers) {
        return new DrunkStateImpl(this.timestamp, this.kickedTimestamp, modifiers);
    }

    @Override
    public double modifierValue(String modifierName) {
        for (Map.Entry<DrunkenModifier, Double> entry : this.modifiers.entrySet()) {
            if (!entry.getKey().name().equals(modifierName)) continue;
            return entry.getValue();
        }
        throw new IllegalArgumentException("Unknown modifier: " + modifierName);
    }

    @Override
    public List<Pair<DrunkenModifier, Double>> additionalModifierData() {
        return this.modifiers.entrySet().stream().map(entry -> new Pair<DrunkenModifier, Double>((DrunkenModifier)entry.getKey(), (Double)entry.getValue())).filter(pair -> ((DrunkenModifier)pair.first()).minValue() != ((Double)pair.second()).doubleValue()).toList();
    }

    @Override
    public DrunkStateImpl withPassOut(long kickedTimestamp) {
        return new DrunkStateImpl(this.timestamp, kickedTimestamp, this.modifiers);
    }

    @Override
    public Pair<DrunkState, Boolean> cascadeModifier(DrunkenModifier modifierToAdd, double valueChange) {
        ImmutableMap.Builder newModifiers = new ImmutableMap.Builder();
        Map<String, Double> variables = DrunkStateImpl.compileVariables(this.modifiers, modifierToAdd, valueChange);
        boolean cascadedOnSelf = false;
        for (Map.Entry<DrunkenModifier, Double> entry : this.modifiers.entrySet()) {
            double diff = entry.getKey().dependency().evaluate(variables);
            if (diff != 0.0) {
                newModifiers.put((Object)entry.getKey(), (Object)(entry.getValue() + diff));
                if (!modifierToAdd.equals(entry.getKey())) continue;
                cascadedOnSelf = true;
                continue;
            }
            newModifiers.put((Object)entry.getKey(), (Object)entry.getValue());
        }
        return new Pair<DrunkState, Boolean>(new DrunkStateImpl(this.timestamp, this.kickedTimestamp, (Map<DrunkenModifier, Double>)newModifiers.build()), cascadedOnSelf);
    }

    @Override
    public Map<String, Double> asVariables() {
        return DrunkStateImpl.compileVariables(this.modifiers, null, 0.0);
    }

    @Override
    public Map<String, Double> asVariables(DrunkenModifier modifier, double valueChange) {
        return DrunkStateImpl.compileVariables(this.modifiers, modifier, valueChange);
    }

    public static Map<String, Double> compileVariables(Map<DrunkenModifier, Double> modifiers, @Nullable DrunkenModifier modifierToAdd, double valueChange) {
        HashMap<String, Double> output = new HashMap<String, Double>();
        for (DrunkenModifier modifier : DrunkenModifierSection.modifiers().drunkenModifiers()) {
            Double value = modifiers.get(modifier);
            if (value == null) {
                output.put(modifier.name(), modifier.minValue());
                output.put("consumed_" + modifier.name(), 0.0);
                continue;
            }
            output.put(modifier.name(), value);
            if (modifier.equals(modifierToAdd)) {
                output.put("consumed_" + modifierToAdd.name(), valueChange);
                continue;
            }
            output.put("consumed_" + modifier.name(), 0.0);
        }
        return output;
    }
}

