/*
 * Decompiled with CFR 0.152.
 */
package dev.jsinco.brewery.configuration;

import com.google.common.base.Preconditions;
import dev.jsinco.brewery.api.effect.modifier.ModifierExpression;
import dev.jsinco.brewery.api.event.CustomEvent;
import dev.jsinco.brewery.api.event.CustomEventRegistry;
import dev.jsinco.brewery.api.event.EventProbability;
import dev.jsinco.brewery.api.event.EventStep;
import dev.jsinco.brewery.api.event.NamedDrunkEvent;
import dev.jsinco.brewery.api.event.step.ApplyPotionEffect;
import dev.jsinco.brewery.api.event.step.Condition;
import dev.jsinco.brewery.api.event.step.ConditionalWaitStep;
import dev.jsinco.brewery.api.event.step.ConsumeStep;
import dev.jsinco.brewery.api.event.step.SendCommand;
import dev.jsinco.brewery.api.math.RangeD;
import dev.jsinco.brewery.api.moment.Interval;
import dev.jsinco.brewery.api.util.BreweryKey;
import dev.jsinco.brewery.api.util.BreweryRegistry;
import dev.jsinco.brewery.api.util.Logger;
import dev.jsinco.brewery.api.vector.BreweryLocation;
import dev.jsinco.brewery.configuration.DrunkenModifierSection;
import dev.jsinco.brewery.configuration.PukeSection;
import dev.jsinco.brewery.effect.DrunkStateImpl;
import dev.jsinco.brewery.lib.eu.okaeri.configs.ConfigManager;
import dev.jsinco.brewery.lib.eu.okaeri.configs.OkaeriConfig;
import dev.jsinco.brewery.lib.eu.okaeri.configs.annotation.Comment;
import dev.jsinco.brewery.lib.eu.okaeri.configs.annotation.CustomKey;
import dev.jsinco.brewery.lib.eu.okaeri.configs.annotation.Exclude;
import dev.jsinco.brewery.lib.eu.okaeri.configs.serdes.OkaeriSerdesPack;
import dev.jsinco.brewery.lib.eu.okaeri.configs.yaml.snakeyaml.YamlSnakeYamlConfigurer;
import dev.jsinco.brewery.lib.org.yaml.snakeyaml.Yaml;
import dev.jsinco.brewery.time.Duration;
import dev.jsinco.brewery.time.TimeUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import net.kyori.adventure.text.Component;

public class EventSection
extends OkaeriConfig {
    @CustomKey(value="kick-event")
    private KickEventSection kickEvent = new KickEventSection();
    @Comment(value={"How long will a player be passed out?"})
    @CustomKey(value="pass-out-time")
    private Duration.Minutes passOutTime = new Duration.Minutes(TimeUtil.parse("5min"));
    @Comment(value={"Drunken messages to send if the drunk_message event is enabled (not recommended to have enabled, gets a bit spammy)"})
    @CustomKey(value="messages")
    private List<String> drunkMessages = List.of("I love you <random_player_name>, you're my best friend.", "I could do one more.", "Who is she?", "Watch this!", "I'm not drunk. You're drunk.");
    @CustomKey(value="puke")
    private PukeSection puke = new PukeSection();
    @Comment(value={"What events will be randomly chosen over time when the player is drunk"})
    @CustomKey(value="enabled-random-events")
    private List<String> enabledRandomEvents = List.of("puke", "memory_loss", "stumble", "chicken", "nausea", "tunnel_vision", "drunken_walk", "hallucination", "fever", "kaboom");
    @Comment(value={"Teleport destinations for the 'teleport' event"})
    @CustomKey(value="teleport-destinations")
    private List<BreweryLocation.Uncompiled> teleportDestinations = List.of(new BreweryLocation.Uncompiled(0, 70, 0, "world"));
    @Comment(value={"Whether we should find a safe location at the requested coordinates"})
    @CustomKey(value="ensure-safe-location")
    private boolean ensureSafeLocation = true;
    @Comment(value={"Should we randomly offset target locations inside a given radius?", "Set to -1 to use the world's spawn radius"})
    @CustomKey(value="random-offset-radius")
    private int randomOffsetRadius = -1;
    @Comment(value={"How likely should it be that the target location is chosen underground? (%)"})
    @CustomKey(value="underground-chance")
    private int undergroundChance = 25;
    @Comment(value={"Deny joining the server if too drunk"})
    @CustomKey(value="drunken-join-deny-event")
    private DrunkenJoinEvent drunkenJoinDeny = new DrunkenJoinEvent();
    @Comment(value={"Transform text with blurred speech if the player is drunk enough"})
    @CustomKey(value="blurred-speech")
    private boolean blurredSpeech = true;
    @Comment(value={"What upwards velocity the player will get in the kaboom event"})
    @CustomKey(value="kaboom-velocity")
    private double kaboomVelocity = 0.2;
    @Comment(value={"What health players should be set to in the kaboom event", "This will not heal them when they have less HP"})
    @CustomKey(value="kaboom-health")
    private double kaboomHealth = 12.0;
    @Comment(value={"The duration where player freezes for the fever event"})
    @CustomKey(value="fever-freezing-time")
    private Duration.Ticks feverFreezingTime = new Duration.Ticks(200L);
    @Comment(value={"The duration where player freezes for the fever event"})
    @CustomKey(value="fever-burning-time")
    private Duration.Ticks feverBurnTime = new Duration.Ticks(100L);
    @Comment(value={"Make your own events, see the wiki at https://hangar.papermc.io/BreweryTeam/TheBrewingProject/pages/Wiki/Configuration#-events"})
    @CustomKey(value="custom-events")
    private CustomEventRegistry customEvents = CustomEventRegistry.builder().addEvent(new CustomEvent.Builder().probability(new EventProbability(new ModifierExpression("0.5 * probabilityWeight(alcohol)"), Map.of("alcohol", new RangeD(90.0, null)))).displayName((Component)Component.text((String)"loose memory")).addStep(new EventStep.Builder().addProperty(NamedDrunkEvent.fromKey("pass_out")).build()).addStep(new EventStep.Builder().addProperty(new ConditionalWaitStep(new Condition.JoinedServer())).addProperty(NamedDrunkEvent.fromKey("teleport")).addProperty(new ConsumeStep(Map.of(DrunkenModifierSection.modifiers().modifier("alcohol"), -30.0))).build()).build(BreweryKey.parse("memory_loss"))).addEvent(new CustomEvent.Builder().displayName((Component)Component.text((String)"get tunnel vision")).probability(new EventProbability(new ModifierExpression("probabilityWeight(alcohol)"), Map.of("alcohol", new RangeD(40.0, null)))).addStep(new EventStep.Builder().addProperty(new ApplyPotionEffect("darkness", new Interval(1L, 1L), new Interval(20L, 20L))).build()).build(BreweryKey.parse("tunnel_vision"))).addEvent(new CustomEvent.Builder().displayName((Component)Component.text((String)"feel alcohol withdrawal")).probability(new EventProbability(new ModifierExpression("probabilityWeight(alcohol_addiction)"), Map.of("alcohol", new RangeD(null, 20.0), "alcohol_addiction", new RangeD(50.0, null)))).addStep(new EventStep.Builder().addProperty(new ApplyPotionEffect("poison", new Interval(1L, 1L), new Interval(20L, 20L))).addProperty(new SendCommand("title @player_name@ actionbar {text:\"You are experiencing alcohol withdrawal\",color:\"gray\"}", SendCommand.CommandSenderType.SERVER)).build()).build(BreweryKey.parse("drinking_addiction"))).build();
    @Comment(value={"Change the properties of premade events"})
    @CustomKey(value="named-drunk-event-overrides")
    private List<NamedDrunkEvent> namedDrunkEventsOverride = BreweryRegistry.DRUNK_EVENT.values().stream().toList();
    @Exclude
    private static EventSection instance;

    public static void validate() {
        Preconditions.checkState((instance != null ? 1 : 0) != 0, (Object)"Instance can not be null");
        Map<String, Double> variables = new DrunkStateImpl(0L, -1L).asVariables();
        boolean noneFailed = true;
        for (CustomEvent.Keyed customEvent : instance.customEvents().events()) {
            noneFailed &= EventSection.validateEvent(variables, customEvent.probability(), customEvent.key());
        }
        for (NamedDrunkEvent namedDrunkEvent : instance.namedDrunkEventsOverride()) {
            noneFailed &= EventSection.validateEvent(variables, namedDrunkEvent.probability(), namedDrunkEvent.key());
        }
        Preconditions.checkState((boolean)noneFailed, (Object)"An event has failed validation, please check above exception");
    }

    private static boolean validateEvent(Map<String, Double> variables, EventProbability probability, BreweryKey key) {
        try {
            probability.evaluate(variables);
            for (String modifierName : probability.allowedRanges().keySet()) {
                DrunkenModifierSection.modifiers().modifier(modifierName);
            }
            return true;
        }
        catch (Exception e) {
            Logger.logErr("Invalid event: " + String.valueOf(key));
            Logger.logErr(e);
            return false;
        }
    }

    public static EventSection events() {
        return instance;
    }

    public static void load(File dataFolder, OkaeriSerdesPack ... packs) {
        instance = ConfigManager.create(EventSection.class, it -> {
            it.withConfigurer(new YamlSnakeYamlConfigurer(), packs);
            it.withBindFile(new File(dataFolder, "events.yml"));
            it.withRemoveOrphans(true);
            it.saveDefaults();
            it.load(true);
        });
    }

    public static void migrateEvents(File dataFolder) {
        Object output;
        Yaml yaml = new Yaml();
        File configFile = new File(dataFolder, "config.yml");
        if (!configFile.exists()) {
            return;
        }
        try (FileInputStream inputStream = new FileInputStream(configFile);){
            Map config = (Map)yaml.load(new InputStreamReader((InputStream)inputStream, StandardCharsets.UTF_8));
            if (config == null) {
                return;
            }
            output = config.get("events");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        if (output == null) {
            return;
        }
        try (FileOutputStream outputStream = new FileOutputStream(new File(dataFolder, "events.yml"));){
            yaml.dump(output, new OutputStreamWriter((OutputStream)outputStream, StandardCharsets.UTF_8));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Generated
    public KickEventSection kickEvent() {
        return this.kickEvent;
    }

    @Generated
    public Duration.Minutes passOutTime() {
        return this.passOutTime;
    }

    @Generated
    public List<String> drunkMessages() {
        return this.drunkMessages;
    }

    @Generated
    public PukeSection puke() {
        return this.puke;
    }

    @Generated
    public List<String> enabledRandomEvents() {
        return this.enabledRandomEvents;
    }

    @Generated
    public List<BreweryLocation.Uncompiled> teleportDestinations() {
        return this.teleportDestinations;
    }

    @Generated
    public boolean ensureSafeLocation() {
        return this.ensureSafeLocation;
    }

    @Generated
    public int randomOffsetRadius() {
        return this.randomOffsetRadius;
    }

    @Generated
    public int undergroundChance() {
        return this.undergroundChance;
    }

    @Generated
    public DrunkenJoinEvent drunkenJoinDeny() {
        return this.drunkenJoinDeny;
    }

    @Generated
    public boolean blurredSpeech() {
        return this.blurredSpeech;
    }

    @Generated
    public double kaboomVelocity() {
        return this.kaboomVelocity;
    }

    @Generated
    public double kaboomHealth() {
        return this.kaboomHealth;
    }

    @Generated
    public Duration.Ticks feverFreezingTime() {
        return this.feverFreezingTime;
    }

    @Generated
    public Duration.Ticks feverBurnTime() {
        return this.feverBurnTime;
    }

    @Generated
    public CustomEventRegistry customEvents() {
        return this.customEvents;
    }

    @Generated
    public List<NamedDrunkEvent> namedDrunkEventsOverride() {
        return this.namedDrunkEventsOverride;
    }

    public static class KickEventSection
    extends OkaeriConfig {
        @CustomKey(value="kick-event-message")
        @Comment(value={"The message to send to the player when getting kicked through the passout event"})
        private String kickEventMessage = null;
        @CustomKey(value="kick-server-message")
        @Comment(value={"THe message to send to all players when a player gets kicked through the passout event"})
        private String kickServerMessage = null;

        @Generated
        public String kickEventMessage() {
            return this.kickEventMessage;
        }

        @Generated
        public String kickServerMessage() {
            return this.kickServerMessage;
        }
    }

    public static class DrunkenJoinEvent
    extends OkaeriConfig {
        private boolean enabled = true;
        private EventProbability probability = new EventProbability(new ModifierExpression("85 - alcohol"), Map.of("alcohol", new RangeD(85.0, null)));

        @Generated
        public boolean enabled() {
            return this.enabled;
        }

        @Generated
        public EventProbability probability() {
            return this.probability;
        }
    }
}

