/*
 * Decompiled with CFR 0.152.
 */
package dev.jsinco.brewery.bukkit.structure.serializer;

import com.google.common.base.Preconditions;
import dev.jsinco.brewery.lib.eu.okaeri.configs.schema.GenericsDeclaration;
import dev.jsinco.brewery.lib.eu.okaeri.configs.serdes.DeserializationData;
import dev.jsinco.brewery.lib.eu.okaeri.configs.serdes.ObjectSerializer;
import dev.jsinco.brewery.lib.eu.okaeri.configs.serdes.SerializationData;
import java.util.List;
import lombok.NonNull;
import org.joml.Vector3i;

public class Vector3iSerializer
implements ObjectSerializer<Vector3i> {
    @Override
    public boolean supports(@NonNull Class<? super Vector3i> type) {
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        return Vector3i.class.isAssignableFrom(type);
    }

    @Override
    public void serialize(@NonNull Vector3i object, @NonNull SerializationData data, @NonNull GenericsDeclaration generics) {
        if (object == null) {
            throw new NullPointerException("object is marked non-null but is null");
        }
        if (data == null) {
            throw new NullPointerException("data is marked non-null but is null");
        }
        if (generics == null) {
            throw new NullPointerException("generics is marked non-null but is null");
        }
        data.setValueCollection(List.of(Integer.valueOf(object.x()), Integer.valueOf(object.y()), Integer.valueOf(object.z())), Integer.class);
    }

    @Override
    public Vector3i deserialize(@NonNull DeserializationData data, @NonNull GenericsDeclaration generics) {
        if (data == null) {
            throw new NullPointerException("data is marked non-null but is null");
        }
        if (generics == null) {
            throw new NullPointerException("generics is marked non-null but is null");
        }
        List<Integer> ints = data.getValueAsList(Integer.class);
        Preconditions.checkArgument((ints != null ? 1 : 0) != 0, (Object)"Expected a list of integers");
        Preconditions.checkArgument((ints.size() != 3 ? 1 : 0) != 0, (Object)"Expected a list of integers with 3 elements");
        return new Vector3i(ints.get(0).intValue(), ints.get(1).intValue(), ints.get(2).intValue());
    }
}

