/*
 * Decompiled with CFR 0.152.
 */
package dev.jsinco.brewery.bukkit.structure.serializer;

import dev.jsinco.brewery.api.structure.MaterialTag;
import dev.jsinco.brewery.api.util.Holder;
import dev.jsinco.brewery.bukkit.structure.StructureReadException;
import dev.jsinco.brewery.lib.eu.okaeri.configs.schema.GenericsDeclaration;
import dev.jsinco.brewery.lib.eu.okaeri.configs.serdes.DeserializationData;
import dev.jsinco.brewery.lib.eu.okaeri.configs.serdes.ObjectSerializer;
import dev.jsinco.brewery.lib.eu.okaeri.configs.serdes.SerializationData;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.NonNull;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Registry;
import org.bukkit.Tag;

public class MaterialTagSerializer
implements ObjectSerializer<MaterialTag> {
    private static final Pattern TAG_PATTERN = Pattern.compile("^#");

    @Override
    public boolean supports(@NonNull Class<? super MaterialTag> type) {
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        return MaterialTag.class == type;
    }

    @Override
    public void serialize(@NonNull MaterialTag object, @NonNull SerializationData data, @NonNull GenericsDeclaration generics) {
        if (object == null) {
            throw new NullPointerException("object is marked non-null but is null");
        }
        if (data == null) {
            throw new NullPointerException("data is marked non-null but is null");
        }
        if (generics == null) {
            throw new NullPointerException("generics is marked non-null but is null");
        }
        data.addCollection("materials", object.materials(), Holder.Material.class);
        if (object.xRegion() > 1) {
            data.add("x_region", object.xRegion());
        }
        if (object.yRegion() > 1) {
            data.add("y_region", object.yRegion());
        }
        if (object.zRegion() > 1) {
            data.add("z_region", object.zRegion());
        }
    }

    @Override
    public MaterialTag deserialize(@NonNull DeserializationData data, @NonNull GenericsDeclaration generics) {
        if (data == null) {
            throw new NullPointerException("data is marked non-null but is null");
        }
        if (generics == null) {
            throw new NullPointerException("generics is marked non-null but is null");
        }
        Set<Holder.Material> materials = data.getAsSet("materials", Holder.Material.class);
        Integer xRegion = data.get("x_region", Integer.class);
        Integer yRegion = data.get("y_region", Integer.class);
        Integer zRegion = data.get("z_region", Integer.class);
        return new MaterialTag(materials, xRegion == null || xRegion < 1 ? 1 : xRegion, yRegion == null || yRegion < 1 ? 1 : yRegion, zRegion == null || zRegion < 1 ? 1 : zRegion);
    }

    private static Set<Material> parseMaterials(String materialString) throws StructureReadException {
        String[] split = materialString.split(",");
        HashSet<Material> output = new HashSet<Material>();
        for (String arg : split) {
            Matcher tagMatcher = TAG_PATTERN.matcher(arg);
            if (tagMatcher.find()) {
                String tagName = tagMatcher.replaceAll("").toLowerCase(Locale.ROOT);
                Tag materialsTag = Bukkit.getTag((String)"blocks", (NamespacedKey)NamespacedKey.minecraft((String)tagName), Material.class);
                if (materialsTag == null) {
                    throw new StructureReadException("Unknown material tag: " + String.valueOf(NamespacedKey.minecraft((String)tagName)));
                }
                output.addAll(materialsTag.getValues());
                continue;
            }
            Material material = (Material)Registry.MATERIAL.get(NamespacedKey.minecraft((String)arg.toLowerCase(Locale.ROOT)));
            if (material == null) {
                throw new StructureReadException("Unknown material: " + String.valueOf(NamespacedKey.minecraft((String)arg.toLowerCase(Locale.ROOT))));
            }
            output.add(material);
        }
        return output;
    }
}

