/*
 * Decompiled with CFR 0.152.
 */
package dev.jsinco.brewery.bukkit.migration.breweryx;

import dev.jsinco.brewery.bukkit.migration.breweryx.SeedInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.InvalidKeyException;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class XORUnscrambleStream
extends FilterInputStream {
    private long seed;
    private final List<Long> prevSeeds;
    private SeedInputStream xorStream;
    private boolean running;
    private boolean markRunning;
    private boolean markxor;

    public XORUnscrambleStream(InputStream in, long seed) {
        super(in);
        this.seed = seed;
        this.prevSeeds = null;
    }

    public XORUnscrambleStream(InputStream in, List<Long> seeds) {
        super(in);
        this.seed = seeds.isEmpty() ? 0L : seeds.getFirst();
        this.seed = seeds.isEmpty() ? 0L : seeds.getFirst();
        this.prevSeeds = seeds.size() <= 1 ? List.of() : seeds.subList(1, seeds.size());
    }

    public void start() throws IOException, InvalidKeyException {
        this.running = true;
        if (this.xorStream == null) {
            short id = (short)(this.in.read() << 8 | this.in.read());
            if (id == 0) {
                this.running = false;
                return;
            }
            int parity = this.in.read();
            this.xorStream = new SeedInputStream(this.seed ^ (long)id);
            boolean success = this.checkParity(parity);
            if (success) {
                // empty if block
            }
            if (!success && this.prevSeeds != null) {
                for (int i = this.prevSeeds.size() - 1; i >= 0; --i) {
                    this.seed = this.prevSeeds.get(i);
                    this.xorStream = new SeedInputStream(this.seed ^ (long)id);
                    if (success == this.checkParity(parity)) break;
                }
            }
            if (!success) {
                throw new InvalidKeyException("Could not read scrambled data, is the seed wrong?");
            }
        }
    }

    private boolean checkParity(int parity) {
        return ((parity ^ this.xorStream.read()) & 0xFF) == ((int)(this.seed >> 48) & 0xFF);
    }

    public void stop() {
        this.running = false;
    }

    @Override
    public int read() throws IOException {
        if (!this.running) {
            return this.in.read();
        }
        return (this.in.read() ^ this.xorStream.read()) & 0xFF;
    }

    @Override
    public int read(@NotNull byte[] b, int off, int len) throws IOException {
        if (!this.running) {
            return this.in.read(b, off, len);
        }
        len = this.in.read(b, off, len);
        int i = off;
        while (i < len + off) {
            int n = i++;
            b[n] = (byte)(b[n] ^ this.xorStream.read());
        }
        return len;
    }

    @Override
    public long skip(long n) throws IOException {
        long skipped = this.in.skip(n);
        if (this.running && skipped > 0L) {
            this.xorStream.skip(skipped);
        }
        return skipped;
    }

    @Override
    public void close() throws IOException {
        if (this.xorStream != null) {
            this.xorStream.close();
            this.xorStream = null;
        }
        this.running = false;
        super.close();
    }

    @Override
    public synchronized void reset() throws IOException {
        this.in.reset();
        if (this.markxor) {
            this.xorStream.reset();
        } else {
            this.xorStream = null;
        }
        this.running = this.markRunning;
    }

    @Override
    public synchronized void mark(int readlimit) {
        this.in.mark(readlimit);
        if (this.xorStream != null) {
            this.xorStream.mark(readlimit);
            this.markxor = true;
        }
        this.markRunning = this.running;
    }
}

