/*
 * Decompiled with CFR 0.152.
 */
package dev.jsinco.brewery.bukkit.meta;

import dev.jsinco.brewery.api.meta.ListMetaDataType;
import dev.jsinco.brewery.api.meta.MetaData;
import dev.jsinco.brewery.api.meta.MetaDataType;
import dev.jsinco.brewery.bukkit.meta.MetaDataPdcType;
import dev.jsinco.brewery.bukkit.meta.PdcMetaDataType;
import java.lang.runtime.SwitchBootstraps;
import java.util.List;
import java.util.Objects;
import org.bukkit.NamespacedKey;
import org.bukkit.persistence.ListPersistentDataTypeProvider;
import org.bukkit.persistence.PersistentDataAdapterContext;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.jetbrains.annotations.NotNull;

final class MetaUtil {
    private static final List<PersistentDataType<?, ?>> PRIMITIVES = List.of(PersistentDataType.BYTE, PersistentDataType.SHORT, PersistentDataType.INTEGER, PersistentDataType.LONG, PersistentDataType.FLOAT, PersistentDataType.DOUBLE, PersistentDataType.STRING, PersistentDataType.BYTE_ARRAY, PersistentDataType.INTEGER_ARRAY, PersistentDataType.LONG_ARRAY, PersistentDataType.TAG_CONTAINER, UntypedListDataType.INSTANCE);

    private MetaUtil() {
    }

    static PersistentDataType<?, ?> findType(PersistentDataContainer pdc, NamespacedKey key) {
        return MetaUtil.findType(pdc, key, PRIMITIVES, 0);
    }

    private static PersistentDataType<?, ?> findType(PersistentDataContainer pdc, NamespacedKey key, List<? extends PersistentDataType<?, ?>> types, int depth) {
        if (depth > 10) {
            throw new IllegalArgumentException("No type found for " + String.valueOf(key));
        }
        for (PersistentDataType<?, ?> type : types) {
            if (!pdc.has(key, type)) continue;
            return type;
        }
        return MetaUtil.findType(pdc, key, types.stream().map(arg_0 -> ((ListPersistentDataTypeProvider)PersistentDataType.LIST).listTypeFrom(arg_0)).toList(), depth + 1);
    }

    static PersistentDataType<?, ?> pdcTypeOf(Object value) {
        Object object = value;
        Objects.requireNonNull(object);
        Object object2 = object;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Byte.class, Short.class, Integer.class, Long.class, Float.class, Double.class, String.class, byte[].class, int[].class, long[].class, MetaData.class, PersistentDataContainer.class, List.class}, (Object)object2, n)) {
            case 0 -> {
                Byte ignored = (Byte)object2;
                yield PersistentDataType.BYTE;
            }
            case 1 -> {
                Short ignored = (Short)object2;
                yield PersistentDataType.SHORT;
            }
            case 2 -> {
                Integer ignored = (Integer)object2;
                yield PersistentDataType.INTEGER;
            }
            case 3 -> {
                Long ignored = (Long)object2;
                yield PersistentDataType.LONG;
            }
            case 4 -> {
                Float ignored = (Float)object2;
                yield PersistentDataType.FLOAT;
            }
            case 5 -> {
                Double ignored = (Double)object2;
                yield PersistentDataType.DOUBLE;
            }
            case 6 -> {
                String ignored = (String)object2;
                yield PersistentDataType.STRING;
            }
            case 7 -> {
                byte[] ignored = (byte[])object2;
                yield PersistentDataType.BYTE_ARRAY;
            }
            case 8 -> {
                int[] ignored = (int[])object2;
                yield PersistentDataType.INTEGER_ARRAY;
            }
            case 9 -> {
                long[] ignored = (long[])object2;
                yield PersistentDataType.LONG_ARRAY;
            }
            case 10 -> {
                MetaData ignored = (MetaData)object2;
                yield MetaDataPdcType.INSTANCE;
            }
            case 11 -> {
                PersistentDataContainer ignored = (PersistentDataContainer)object2;
                yield PersistentDataType.TAG_CONTAINER;
            }
            case 12 -> {
                List list = (List)object2;
                yield MetaUtil.pdcListTypeOf(list, 1);
            }
            default -> throw new IllegalArgumentException("No type found for " + value.getClass().getSimpleName());
        };
    }

    private static PersistentDataType<?, ?> pdcListTypeOf(List<?> list, int depth) {
        Object element;
        if (depth > 10) {
            throw new IllegalArgumentException("Requested pdc type of list that was too deeply nested");
        }
        if (list.isEmpty()) {
            return PersistentDataType.LIST.bytes();
        }
        Object obj = element = list.getFirst();
        Objects.requireNonNull(obj);
        Object obj2 = obj;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Byte.class, Short.class, Integer.class, Long.class, Float.class, Double.class, String.class, byte[].class, int[].class, long[].class, MetaData.class, PersistentDataContainer.class, List.class}, obj2, n)) {
            case 0 -> {
                Byte ignored = (Byte)obj2;
                yield PersistentDataType.LIST.bytes();
            }
            case 1 -> {
                Short ignored = (Short)obj2;
                yield PersistentDataType.LIST.shorts();
            }
            case 2 -> {
                Integer ignored = (Integer)obj2;
                yield PersistentDataType.LIST.integers();
            }
            case 3 -> {
                Long ignored = (Long)obj2;
                yield PersistentDataType.LIST.longs();
            }
            case 4 -> {
                Float ignored = (Float)obj2;
                yield PersistentDataType.LIST.floats();
            }
            case 5 -> {
                Double ignored = (Double)obj2;
                yield PersistentDataType.LIST.doubles();
            }
            case 6 -> {
                String ignored = (String)obj2;
                yield PersistentDataType.LIST.strings();
            }
            case 7 -> {
                byte[] ignored = (byte[])obj2;
                yield PersistentDataType.LIST.byteArrays();
            }
            case 8 -> {
                int[] ignored = (int[])obj2;
                yield PersistentDataType.LIST.integerArrays();
            }
            case 9 -> {
                long[] ignored = (long[])obj2;
                yield PersistentDataType.LIST.longArrays();
            }
            case 10 -> {
                MetaData ignored = (MetaData)obj2;
                yield MetaDataPdcType.LIST;
            }
            case 11 -> {
                PersistentDataContainer ignored = (PersistentDataContainer)obj2;
                yield PersistentDataType.LIST.dataContainers();
            }
            case 12 -> {
                List nestedList = (List)obj2;
                yield PersistentDataType.LIST.listTypeFrom(MetaUtil.pdcListTypeOf(nestedList, depth + 1));
            }
            default -> throw new IllegalArgumentException("No type found for list element " + element.getClass().getSimpleName());
        };
    }

    static MetaDataType<?, ?> metaDataTypeOf(Object value) {
        Object object = value;
        Objects.requireNonNull(object);
        Object object2 = object;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Byte.class, Short.class, Integer.class, Long.class, Float.class, Double.class, String.class, byte[].class, int[].class, long[].class, MetaData.class, PersistentDataContainer.class, List.class}, (Object)object2, n)) {
            case 0 -> {
                Byte ignored = (Byte)object2;
                yield MetaDataType.BYTE;
            }
            case 1 -> {
                Short ignored = (Short)object2;
                yield MetaDataType.SHORT;
            }
            case 2 -> {
                Integer ignored = (Integer)object2;
                yield MetaDataType.INTEGER;
            }
            case 3 -> {
                Long ignored = (Long)object2;
                yield MetaDataType.LONG;
            }
            case 4 -> {
                Float ignored = (Float)object2;
                yield MetaDataType.FLOAT;
            }
            case 5 -> {
                Double ignored = (Double)object2;
                yield MetaDataType.DOUBLE;
            }
            case 6 -> {
                String ignored = (String)object2;
                yield MetaDataType.STRING;
            }
            case 7 -> {
                byte[] ignored = (byte[])object2;
                yield MetaDataType.BYTE_ARRAY;
            }
            case 8 -> {
                int[] ignored = (int[])object2;
                yield MetaDataType.INTEGER_ARRAY;
            }
            case 9 -> {
                long[] ignored = (long[])object2;
                yield MetaDataType.LONG_ARRAY;
            }
            case 10 -> {
                MetaData ignored = (MetaData)object2;
                yield MetaDataType.CONTAINER;
            }
            case 11 -> {
                PersistentDataContainer pdc = (PersistentDataContainer)object2;
                yield PdcMetaDataType.with(pdc.getAdapterContext());
            }
            case 12 -> {
                List list = (List)object2;
                yield MetaUtil.metaDataListTypeOf(list, 1);
            }
            default -> throw new IllegalArgumentException("No type found for " + value.getClass().getSimpleName());
        };
    }

    private static MetaDataType<?, ?> metaDataListTypeOf(List<?> list, int depth) {
        Object element;
        if (depth > 10) {
            throw new IllegalArgumentException("Requested meta data type of list that was too deeply nested");
        }
        if (list.isEmpty()) {
            return MetaDataType.BYTE_LIST;
        }
        Object obj = element = list.getFirst();
        Objects.requireNonNull(obj);
        Object obj2 = obj;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Byte.class, Short.class, Integer.class, Long.class, Float.class, Double.class, String.class, byte[].class, int[].class, long[].class, MetaData.class, PersistentDataContainer.class, List.class}, obj2, n)) {
            case 0 -> {
                Byte ignored = (Byte)obj2;
                yield MetaDataType.BYTE_LIST;
            }
            case 1 -> {
                Short ignored = (Short)obj2;
                yield MetaDataType.SHORT_LIST;
            }
            case 2 -> {
                Integer ignored = (Integer)obj2;
                yield MetaDataType.INTEGER_LIST;
            }
            case 3 -> {
                Long ignored = (Long)obj2;
                yield MetaDataType.LONG_LIST;
            }
            case 4 -> {
                Float ignored = (Float)obj2;
                yield MetaDataType.FLOAT_LIST;
            }
            case 5 -> {
                Double ignored = (Double)obj2;
                yield MetaDataType.DOUBLE_LIST;
            }
            case 6 -> {
                String ignored = (String)obj2;
                yield MetaDataType.STRING_LIST;
            }
            case 7 -> {
                byte[] ignored = (byte[])obj2;
                yield MetaDataType.BYTE_ARRAY_LIST;
            }
            case 8 -> {
                int[] ignored = (int[])obj2;
                yield MetaDataType.INTEGER_ARRAY_LIST;
            }
            case 9 -> {
                long[] ignored = (long[])obj2;
                yield MetaDataType.LONG_ARRAY_LIST;
            }
            case 10 -> {
                MetaData ignored = (MetaData)obj2;
                yield MetaDataType.CONTAINER_LIST;
            }
            case 11 -> {
                PersistentDataContainer pdc = (PersistentDataContainer)obj2;
                yield ListMetaDataType.from(PdcMetaDataType.with(pdc.getAdapterContext()));
            }
            case 12 -> {
                List nestedList = (List)obj2;
                yield ListMetaDataType.from(MetaUtil.metaDataListTypeOf(nestedList, depth + 1));
            }
            default -> throw new IllegalArgumentException("No type found for list element " + element.getClass().getSimpleName());
        };
    }

    private static class UntypedListDataType
    implements MetaDataType<List<?>, List<?>>,
    PersistentDataType<List<?>, List<?>> {
        public static final UntypedListDataType INSTANCE = new UntypedListDataType();

        private UntypedListDataType() {
        }

        @Override
        @NotNull
        public Class<List<?>> getPrimitiveType() {
            return List.class;
        }

        @Override
        @NotNull
        public Class<List<?>> getComplexType() {
            return List.class;
        }

        @NotNull
        public List<?> toPrimitive(@NotNull List<?> complex, @NotNull PersistentDataAdapterContext context) {
            return complex;
        }

        @Override
        public List<?> toPrimitive(List<?> complex) {
            return complex;
        }

        @NotNull
        public List<?> fromPrimitive(@NotNull List<?> primitive, @NotNull PersistentDataAdapterContext context) {
            return primitive;
        }

        @Override
        public List<?> toComplex(List<?> primitive) {
            return primitive;
        }
    }
}

