/*
 * Decompiled with CFR 0.152.
 */
package dev.jsinco.brewery.bukkit.integration.item;

import dev.jsinco.brewery.bukkit.TheBrewingProject;
import dev.jsinco.brewery.bukkit.api.integration.ItemIntegration;
import dev.jsinco.brewery.util.ClassUtil;
import io.lumine.mythic.bukkit.MythicBukkit;
import io.lumine.mythic.bukkit.adapters.BukkitItemStack;
import io.lumine.mythic.core.items.MythicItem;
import io.lumine.mythiccrucible.events.MythicCrucibleLoadedEvent;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import net.kyori.adventure.text.Component;
import org.bukkit.Bukkit;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.Nullable;
import org.jspecify.annotations.NonNull;

public class MythicIntegration
implements ItemIntegration,
Listener {
    private final CompletableFuture<Void> initialized = new CompletableFuture();

    @Override
    public Optional<ItemStack> createItem(String id) {
        return this.getMythicItem(id).map(item -> item.generateItemStack(1)).map(BukkitItemStack.class::cast).map(BukkitItemStack::getItemStack);
    }

    @Override
    public boolean isIngredient(String id) {
        return this.getMythicItem(id).isPresent();
    }

    @Override
    @Nullable
    public Component displayName(String id) {
        return this.createItem(id).map(ItemStack::displayName).orElse(null);
    }

    private Optional<MythicItem> getMythicItem(String name) {
        Optional result = MythicBukkit.inst().getItemManager().getItem(name);
        if (result.isPresent()) {
            return result;
        }
        return MythicBukkit.inst().getItemManager().getItems().stream().filter(item -> item.getInternalName().equalsIgnoreCase(name)).findFirst();
    }

    @Override
    @Nullable
    public String getItemId(ItemStack itemStack) {
        return MythicBukkit.inst().getItemManager().getMythicTypeFromItem(itemStack);
    }

    @Override
    public @NonNull CompletableFuture<Void> initialized() {
        return this.initialized;
    }

    @Override
    public boolean isEnabled() {
        return ClassUtil.exists("io.lumine.mythiccrucible.events.MythicCrucibleLoadedEvent");
    }

    @Override
    public String getId() {
        return "mythic";
    }

    @Override
    public void onEnable() {
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)TheBrewingProject.getInstance());
    }

    @EventHandler
    public void onMythicReload(MythicCrucibleLoadedEvent event) {
        this.initialized.completeAsync(() -> null);
    }
}

