/*
 * Decompiled with CFR 0.152.
 */
package dev.jsinco.brewery.bukkit.effect.named;

import dev.jsinco.brewery.api.event.EventPropertyExecutable;
import dev.jsinco.brewery.api.event.EventStep;
import dev.jsinco.brewery.api.event.NamedDrunkEvent;
import dev.jsinco.brewery.api.util.Pair;
import dev.jsinco.brewery.bukkit.TheBrewingProject;
import io.papermc.paper.threadedregions.scheduler.ScheduledTask;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.NotNull;

public class DrunkenWalkNamedExecutable
implements EventPropertyExecutable {
    private static final int DRUNKEN_WALK_DURATION = 400;

    @Override
    @NotNull
    public EventPropertyExecutable.ExecutionResult execute(UUID contextPlayer, List<? extends EventStep> events, int index) {
        Player player = Bukkit.getPlayer((UUID)contextPlayer);
        if (player == null) {
            return EventPropertyExecutable.ExecutionResult.CONTINUE;
        }
        int duration = RANDOM.nextInt(200, 600);
        DrunkenWalkHandler drunkenWalkHandler = new DrunkenWalkHandler(duration, player);
        player.getScheduler().runAtFixedRate((Plugin)TheBrewingProject.getInstance(), drunkenWalkHandler::tick, () -> {}, 1L, 1L);
        TheBrewingProject.getInstance().getActiveEventsRegistry().registerActiveEvent(player.getUniqueId(), NamedDrunkEvent.fromKey("drunken_walk"), duration);
        return EventPropertyExecutable.ExecutionResult.CONTINUE;
    }

    @Override
    public int priority() {
        return -1;
    }

    static class DrunkenWalkHandler {
        private final LinkedList<Pair<Vector, Integer>> vectors;
        private int currentTimestamp;
        private int duration;
        private int timestamp = 0;
        private final Player player;
        private Vector currentPush;
        private static int DIRECTION_INTERVAL = 20;
        private static double MINIMUM_PUSH_MAGNITUDE = 0.1;
        private static double MAXIMUM_PUSH_MAGNITUDE = 0.4;
        private static final Random RANDOM = new Random();

        DrunkenWalkHandler(int duration, Player player) {
            this.duration = duration;
            this.player = player;
            this.vectors = this.compileRandomVectors(duration);
            this.pollNewCurrentVector(this.vectors);
        }

        private void pollNewCurrentVector(LinkedList<Pair<Vector, Integer>> vectors) {
            Pair<Vector, Integer> pair = vectors.poll();
            this.currentPush = pair == null ? null : pair.first();
            this.currentTimestamp = pair == null ? 0 : pair.second();
        }

        private LinkedList<Pair<Vector, Integer>> compileRandomVectors(int duration) {
            int amount = duration / DIRECTION_INTERVAL;
            LinkedList<Pair<Vector, Integer>> output = new LinkedList<Pair<Vector, Integer>>();
            for (int i = 0; i < amount; ++i) {
                double angle = RANDOM.nextDouble(Math.PI * 2);
                double radius = RANDOM.nextDouble(MINIMUM_PUSH_MAGNITUDE, MAXIMUM_PUSH_MAGNITUDE);
                Vector vector = new Vector(Math.cos(angle), 0.0, Math.sin(angle)).multiply(radius);
                output.add(new Pair<Vector, Integer>(vector, i * DIRECTION_INTERVAL));
            }
            return output;
        }

        public void tick(ScheduledTask task) {
            if (this.duration <= this.timestamp++ || this.currentPush == null) {
                task.cancel();
                return;
            }
            Vector walk = TheBrewingProject.getInstance().getPlayerWalkListener().getRegisteredMovement(this.player.getUniqueId());
            if (!this.player.isOnline() || !this.player.isOnGround() || walk == null || walk.lengthSquared() == 0.0 || TheBrewingProject.getInstance().getActiveEventsRegistry().hasActiveEvent(this.player.getUniqueId(), NamedDrunkEvent.fromKey("stumble"))) {
                return;
            }
            Pair<Vector, Integer> next = this.vectors.peek();
            if (next == null) {
                this.player.setVelocity(this.currentPush);
                return;
            }
            Vector nextPush = next.first();
            int nextTimestamp = next.second();
            if (nextTimestamp <= this.timestamp) {
                this.pollNewCurrentVector(this.vectors);
                this.player.setVelocity(this.currentPush);
                return;
            }
            double interpolation = (double)(nextTimestamp - this.timestamp) / (double)(nextTimestamp - this.currentTimestamp);
            Vector newPush = this.currentPush.clone().multiply(interpolation).add(nextPush.clone().multiply(1.0 - interpolation));
            this.player.setVelocity(newPush);
        }
    }
}

