/*
 * Decompiled with CFR 0.152.
 */
package dev.jsinco.brewery.bukkit.configuration.serializer;

import dev.jsinco.brewery.api.event.EventData;
import dev.jsinco.brewery.api.event.IntegrationEvent;
import dev.jsinco.brewery.bukkit.api.integration.EventIntegration;
import dev.jsinco.brewery.lib.eu.okaeri.configs.schema.GenericsDeclaration;
import dev.jsinco.brewery.lib.eu.okaeri.configs.serdes.DeserializationData;
import dev.jsinco.brewery.lib.eu.okaeri.configs.serdes.ObjectSerializer;
import dev.jsinco.brewery.lib.eu.okaeri.configs.serdes.SerializationData;
import lombok.NonNull;

public record IntegrationEventSerializer<E extends IntegrationEvent>(EventIntegration<E> integration) implements ObjectSerializer<E>
{
    @Override
    public boolean supports(@NonNull Class<? super E> type) {
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        return this.integration.eClass().isAssignableFrom(type);
    }

    @Override
    public void serialize(@NonNull E object, @NonNull SerializationData data, @NonNull GenericsDeclaration generics) {
        if (object == null) {
            throw new NullPointerException("object is marked non-null but is null");
        }
        if (data == null) {
            throw new NullPointerException("data is marked non-null but is null");
        }
        if (generics == null) {
            throw new NullPointerException("generics is marked non-null but is null");
        }
        EventData eventData = this.integration.convertToData(object);
        data.setValue(eventData.serialized());
    }

    @Override
    public E deserialize(@NonNull DeserializationData data, @NonNull GenericsDeclaration generics) {
        if (data == null) {
            throw new NullPointerException("data is marked non-null but is null");
        }
        if (generics == null) {
            throw new NullPointerException("generics is marked non-null but is null");
        }
        String serialized = data.getValue(String.class);
        if (serialized == null) {
            return null;
        }
        return (E)((IntegrationEvent)this.integration.convertToEvent(EventData.deserialize(serialized)).orElse(null));
    }
}

