/*
 * Decompiled with CFR 0.152.
 */
package dev.jsinco.brewery.bukkit.command.argument;

import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import dev.jsinco.brewery.api.ingredient.Ingredient;
import dev.jsinco.brewery.bukkit.TheBrewingProject;
import dev.jsinco.brewery.bukkit.ingredient.BukkitIngredientManager;
import dev.jsinco.brewery.bukkit.util.BukkitMessageUtil;
import dev.jsinco.brewery.recipes.RecipeRegistryImpl;
import io.papermc.paper.command.brigadier.MessageComponentSerializer;
import io.papermc.paper.command.brigadier.argument.CustomArgumentType;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.jetbrains.annotations.NotNull;

public class IngredientsArgument
implements CustomArgumentType.Converted<Map<Ingredient, Integer>, String> {
    private static final SimpleCommandExceptionType TIMEOUT = new SimpleCommandExceptionType((Message)MessageComponentSerializer.message().serialize((Component)Component.text((String)"Command timed out, another integrated plugin probably failed on startup")));
    private static final SimpleCommandExceptionType INVALID_SYNTAX = new SimpleCommandExceptionType(BukkitMessageUtil.toBrigadier("tbp.command.invalid-ingredient-syntax", new TagResolver[0]));

    public Map<Ingredient, Integer> convert(String nativeType) throws CommandSyntaxException {
        try {
            return BukkitIngredientManager.INSTANCE.getIngredientsWithAmount(IngredientsArgument.splitIngredients(nativeType).stream().map(String::strip).filter(string -> !string.isBlank()).toList(), true).orTimeout(50L, TimeUnit.MILLISECONDS).join();
        }
        catch (CompletionException e) {
            if (e.getCause() != null && e.getCause() instanceof TimeoutException) {
                throw TIMEOUT.create();
            }
            throw e;
        }
    }

    private static List<String> splitIngredients(String input) throws CommandSyntaxException {
        if (input.isEmpty()) {
            return List.of();
        }
        StringBuilder builder = new StringBuilder();
        ArrayList<String> output = new ArrayList<String>();
        int curlyBracketsDepth = 0;
        for (char character : input.toCharArray()) {
            if (curlyBracketsDepth == 0 && (character == ' ' || character == ',')) {
                String next = builder.toString();
                builder = new StringBuilder();
                if (next.isEmpty()) continue;
                output.add(next);
                continue;
            }
            if (character == '{') {
                ++curlyBracketsDepth;
            }
            if (character == '}' && --curlyBracketsDepth < 0) {
                throw INVALID_SYNTAX.create();
            }
            builder.append(character);
        }
        if (curlyBracketsDepth > 0) {
            throw INVALID_SYNTAX.create();
        }
        if (!builder.isEmpty()) {
            output.add(builder.toString());
        }
        return output;
    }

    public ArgumentType<String> getNativeType() {
        return StringArgumentType.string();
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(@NotNull CommandContext<S> context, SuggestionsBuilder builder) {
        String last;
        List<String> splitIngredients;
        if (builder.getRemainingLowerCase().isBlank()) {
            builder.suggest("\"");
            return builder.buildFuture();
        }
        if (!builder.getRemainingLowerCase().startsWith("\"")) {
            return builder.buildFuture();
        }
        String remainingLowerCase = builder.getRemainingLowerCase().substring(1);
        try {
            splitIngredients = IngredientsArgument.splitIngredients(remainingLowerCase);
        }
        catch (Exception e) {
            return builder.buildFuture();
        }
        if (remainingLowerCase.endsWith(",") || remainingLowerCase.endsWith(" ") || remainingLowerCase.isEmpty()) {
            last = "";
        } else {
            last = splitIngredients.getLast();
            splitIngredients.removeLast();
        }
        ((RecipeRegistryImpl)TheBrewingProject.getInstance().getRecipeRegistry()).registeredIngredients().stream().map(Ingredient::getKey).map(ingredientKey -> ingredientKey.replaceAll("^minecraft:", "")).filter(ingredientKey -> ingredientKey.startsWith(last)).map(string -> "\"" + (String)(splitIngredients.isEmpty() ? "" : String.join((CharSequence)",", splitIngredients) + ",") + string).forEach(arg_0 -> ((SuggestionsBuilder)builder).suggest(arg_0));
        return builder.buildFuture();
    }
}

