/*
 * Decompiled with CFR 0.152.
 */
package dev.jsinco.brewery.bukkit.command;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import dev.jsinco.brewery.api.brew.Brew;
import dev.jsinco.brewery.api.brew.BrewQuality;
import dev.jsinco.brewery.api.brew.BrewScore;
import dev.jsinco.brewery.api.recipe.Recipe;
import dev.jsinco.brewery.brew.BrewImpl;
import dev.jsinco.brewery.bukkit.brew.BrewAdapter;
import dev.jsinco.brewery.bukkit.command.BreweryCommand;
import dev.jsinco.brewery.bukkit.command.argument.EnumArgument;
import dev.jsinco.brewery.bukkit.command.argument.RecipeArgument;
import dev.jsinco.brewery.bukkit.recipe.BukkitRecipeResult;
import dev.jsinco.brewery.recipes.BrewScoreImpl;
import dev.jsinco.brewery.util.IngredientUtil;
import dev.jsinco.brewery.util.MessageUtil;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import io.papermc.paper.command.brigadier.Commands;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class ReplicateCommand {
    public static ArgumentBuilder<CommandSourceStack, ?> command() {
        return ((RequiredArgumentBuilder)Commands.argument((String)"recipe-name", (ArgumentType)new RecipeArgument()).then(Commands.argument((String)"quality", new EnumArgument<BrewQuality>(BrewQuality.class)).executes(context -> {
            Recipe recipe = (Recipe)context.getArgument("recipe-name", Recipe.class);
            BrewQuality quality = (BrewQuality)((Object)((Object)context.getArgument("quality", BrewQuality.class)));
            Player target = BreweryCommand.getPlayer((CommandContext<CommandSourceStack>)context);
            ReplicateCommand.givePlayerBrew(recipe, (CommandContext<CommandSourceStack>)context, target, quality);
            return 1;
        }))).executes(context -> {
            Recipe recipe = (Recipe)context.getArgument("recipe-name", Recipe.class);
            Player target = BreweryCommand.getPlayer((CommandContext<CommandSourceStack>)context);
            ReplicateCommand.givePlayerBrew(recipe, (CommandContext<CommandSourceStack>)context, target, BrewQuality.EXCELLENT);
            return 1;
        });
    }

    private static void givePlayerBrew(Recipe<ItemStack> recipe, CommandContext<CommandSourceStack> context, Player target, BrewQuality quality) {
        BrewImpl brew = new BrewImpl(IngredientUtil.sanitizeSteps(recipe.getSteps()));
        BrewScore score = brew.score(recipe);
        if (score instanceof BrewScoreImpl) {
            BrewScoreImpl scoreImpl = (BrewScoreImpl)score;
            scoreImpl.setQualityOverride(quality);
        }
        ItemStack brewItem = recipe.getRecipeResult(quality).newBrewItem(score, brew, new Brew.State.Other());
        brewItem.editPersistentDataContainer(pdc -> {
            BrewAdapter.applyBrewTags(pdc, recipe, score.score(), ((BukkitRecipeResult)recipe.getRecipeResult(quality)).getName());
            BrewAdapter.applyBrewData(pdc, brew);
        });
        if (!target.getInventory().addItem(new ItemStack[]{brewItem}).isEmpty()) {
            target.getLocation().getWorld().dropItem(target.getLocation(), brewItem);
        }
        MessageUtil.message((Audience)((CommandSourceStack)context.getSource()).getSender(), "tbp.command.create.success", new TagResolver[]{Placeholder.component((String)"brew_name", (ComponentLike)brewItem.effectiveName())});
    }
}

