/*
 * Decompiled with CFR 0.152.
 */
package dev.jsinco.brewery.bukkit.command;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import dev.jsinco.brewery.api.brew.Brew;
import dev.jsinco.brewery.api.brew.BrewingStep;
import dev.jsinco.brewery.brew.BrewImpl;
import dev.jsinco.brewery.bukkit.brew.BrewAdapter;
import dev.jsinco.brewery.bukkit.command.BreweryCommand;
import dev.jsinco.brewery.bukkit.command.argument.EnumArgument;
import dev.jsinco.brewery.bukkit.command.argument.OfflinePlayerArgument;
import dev.jsinco.brewery.bukkit.command.argument.OfflinePlayerSelectorArgumentResolver;
import dev.jsinco.brewery.bukkit.util.BukkitMessageUtil;
import dev.jsinco.brewery.util.MessageUtil;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import io.papermc.paper.command.brigadier.Commands;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.minimessage.tag.resolver.Formatter;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;

public class BrewerCommand {
    private static DynamicCommandExceptionType INDEX_OUT_OF_BOUNDS = new DynamicCommandExceptionType(object -> BukkitMessageUtil.toBrigadier("tbp.command.brewer.step-out-of-bounds", Formatter.number((String)"max_index", (Number)((Number)object))));
    private static final int PLAYER_INVENTORY_SIZE = 41;

    public static ArgumentBuilder<CommandSourceStack, ?> command() {
        RequiredArgumentBuilder withIndex = Commands.argument((String)"inventory_slot", (ArgumentType)IntegerArgumentType.integer((int)0, (int)40));
        BrewerCommand.appendBrewerModification(withIndex);
        RequiredArgumentBuilder withNamedSlot = Commands.argument((String)"equipment_slot", new EnumArgument<EquipmentSlot>(EquipmentSlot.class));
        BrewerCommand.appendBrewerModification(withNamedSlot);
        LiteralArgumentBuilder command = Commands.literal((String)"brewer");
        command.then((ArgumentBuilder)withNamedSlot);
        command.then((ArgumentBuilder)withIndex);
        command.then(BreweryCommand.playerBranch(arg_0 -> BrewerCommand.lambda$command$1((ArgumentBuilder)withNamedSlot, (ArgumentBuilder)withIndex, arg_0)));
        BrewerCommand.appendBrewerModification(command);
        return command;
    }

    private static void appendBrewerModification(ArgumentBuilder<CommandSourceStack, ?> builder) {
        builder.then(Commands.literal((String)"add").then(((RequiredArgumentBuilder)Commands.argument((String)"brewers", (ArgumentType)OfflinePlayerArgument.MULTIPLE).then(Commands.argument((String)"step", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(context -> BrewerCommand.modifyBrew((CommandContext<CommandSourceStack>)context, BrewerCommand::addBrewers, BrewerCommand::addBrewersToLast, "tbp.command.brewer.add")))).executes(context -> BrewerCommand.modifyBrew((CommandContext<CommandSourceStack>)context, BrewerCommand::addBrewers, BrewerCommand::addBrewersToLast, "tbp.command.brewer.add")))).then(Commands.literal((String)"remove").then(((RequiredArgumentBuilder)Commands.argument((String)"brewers", (ArgumentType)OfflinePlayerArgument.MULTIPLE).then(Commands.argument((String)"step", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(context -> BrewerCommand.modifyBrew((CommandContext<CommandSourceStack>)context, BrewerCommand::removeBrewers, "tbp.command.brewer.remove")))).executes(context -> BrewerCommand.modifyBrew((CommandContext<CommandSourceStack>)context, BrewerCommand::removeBrewers, "tbp.command.brewer.remove")))).then(Commands.literal((String)"set").then(((RequiredArgumentBuilder)Commands.argument((String)"brewers", (ArgumentType)OfflinePlayerArgument.MULTIPLE).then(Commands.argument((String)"step", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(context -> BrewerCommand.modifyBrew((CommandContext<CommandSourceStack>)context, BrewerCommand::setBrewers, BrewerCommand::setBrewersClearingOtherSteps, "tbp.command.brewer.set")))).executes(context -> BrewerCommand.modifyBrew((CommandContext<CommandSourceStack>)context, BrewerCommand::setBrewers, BrewerCommand::setBrewersClearingOtherSteps, "tbp.command.brewer.set")))).then(((LiteralArgumentBuilder)Commands.literal((String)"clear").then(Commands.argument((String)"step", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(context -> BrewerCommand.modifyBrew((CommandContext<CommandSourceStack>)context, BrewerCommand::clearBrewers, "tbp.command.brewer.clear")))).executes(context -> BrewerCommand.modifyBrew((CommandContext<CommandSourceStack>)context, BrewerCommand::clearBrewers, "tbp.command.brewer.clear")));
    }

    private static BrewingStep addBrewers(BrewingStep step, List<UUID> brewers) {
        if (step instanceof BrewingStep.AuthoredStep) {
            BrewingStep.AuthoredStep authoredStep = (BrewingStep.AuthoredStep)step;
            return authoredStep.withBrewers(brewers);
        }
        return step;
    }

    private static Brew addBrewersToLast(Brew brew, List<UUID> brewers) {
        return BrewerCommand.lastAuthoredStepIndex(brew).map(index -> brew.withModifiedStep((int)index, ignored -> BrewerCommand.addBrewers(brew.getSteps().get((int)index), brewers))).orElse(brew);
    }

    private static BrewingStep removeBrewers(BrewingStep step, List<UUID> brewers) {
        if (step instanceof BrewingStep.AuthoredStep) {
            BrewingStep.AuthoredStep authoredStep = (BrewingStep.AuthoredStep)step;
            return authoredStep.withBrewersReplaced(authoredStep.brewers().stream().filter(uuid -> brewers.stream().noneMatch(uuid::equals)).toList());
        }
        return step;
    }

    private static BrewingStep setBrewers(BrewingStep step, List<UUID> brewers) {
        if (step instanceof BrewingStep.AuthoredStep) {
            BrewingStep.AuthoredStep authoredStep = (BrewingStep.AuthoredStep)step;
            return authoredStep.withBrewersReplaced(brewers);
        }
        return step;
    }

    private static Brew setBrewersClearingOtherSteps(Brew brew, List<UUID> brewers) {
        Brew cleared = BrewerCommand.modifyAllBrewSteps(brew, BrewerCommand::clearBrewers, brewers);
        return BrewerCommand.lastAuthoredStepIndex(cleared).map(index -> brew.withModifiedStep((int)index, ignored -> BrewerCommand.addBrewers(cleared.getSteps().get((int)index), brewers))).orElse(brew);
    }

    private static BrewingStep clearBrewers(BrewingStep step, List<UUID> ignored) {
        if (step instanceof BrewingStep.AuthoredStep) {
            BrewingStep.AuthoredStep authoredStep = (BrewingStep.AuthoredStep)step;
            return authoredStep.withBrewersReplaced(List.of());
        }
        return step;
    }

    private static int modifyBrew(CommandContext<CommandSourceStack> context, BiFunction<BrewingStep, List<UUID>, BrewingStep> stepOperation, String successMessageKey) throws CommandSyntaxException {
        return BrewerCommand.modifyBrew(context, stepOperation, (brew, brewers) -> BrewerCommand.modifyAllBrewSteps(brew, stepOperation, brewers), successMessageKey);
    }

    private static int modifyBrew(CommandContext<CommandSourceStack> context, BiFunction<BrewingStep, List<UUID>, BrewingStep> stepOperation, BiFunction<Brew, List<UUID>, Brew> brewOperation, String successMessageKey) throws CommandSyntaxException {
        CommandSender sender = ((CommandSourceStack)context.getSource()).getSender();
        Slot targetSlot = BrewerCommand.getTargetSlot(context, BreweryCommand.getPlayer(context));
        ItemStack itemStack = targetSlot.itemGetter.get();
        if (itemStack.isEmpty()) {
            MessageUtil.message((Audience)sender, "tbp.command.info.not-a-brew", new TagResolver[0]);
            return 1;
        }
        Optional<Integer> stepIndex = BrewerCommand.getArgument(context, "step", Integer.TYPE);
        List<OfflinePlayer> brewers = BrewerCommand.getBrewers(context);
        List<UUID> brewerUuids = brewers.stream().map(OfflinePlayer::getUniqueId).toList();
        Optional<Brew> brewOptional = BrewAdapter.fromItem(itemStack);
        if (stepIndex.isPresent() && brewOptional.isPresent() && brewOptional.get().stepAmount() <= stepIndex.get()) {
            throw INDEX_OUT_OF_BOUNDS.create((Object)(brewOptional.get().stepAmount() - 1));
        }
        if (brewOptional.map(Brew::stepAmount).filter(stepAmount -> stepAmount <= 0).isPresent()) {
            MessageUtil.message((Audience)sender, "tbp.command.brewer.empty", new TagResolver[0]);
            return 1;
        }
        brewOptional.map(brew -> stepIndex.map(index -> brew.withModifiedStep((int)index, brewingStep -> (BrewingStep)stepOperation.apply((BrewingStep)brewingStep, brewerUuids))).orElseGet(() -> (Brew)brewOperation.apply((Brew)brew, brewerUuids))).ifPresentOrElse(brew -> {
            targetSlot.itemSetter().accept(BrewAdapter.toItem(brew, new Brew.State.Other()));
            MessageUtil.message((Audience)sender, successMessageKey, new TagResolver[]{Placeholder.component((String)"brewers", (ComponentLike)((ComponentLike)brewers.stream().map(BrewerCommand::getName).map(Component::text).collect(Component.toComponent((Component)Component.text((String)", ")))))});
        }, () -> MessageUtil.message((Audience)sender, "tbp.command.info.not-a-brew", new TagResolver[0]));
        return 1;
    }

    private static Brew modifyAllBrewSteps(Brew brew, BiFunction<BrewingStep, List<UUID>, BrewingStep> operation, List<UUID> brewers) {
        return new BrewImpl(brew.getSteps().stream().map(brewingStep -> (BrewingStep)operation.apply((BrewingStep)brewingStep, brewers)).toList());
    }

    private static Optional<Integer> lastAuthoredStepIndex(Brew brew) {
        for (int i = brew.getSteps().size() - 1; i >= 0; --i) {
            BrewingStep step = brew.getSteps().get(i);
            if (!(step instanceof BrewingStep.AuthoredStep)) continue;
            return Optional.of(i);
        }
        return Optional.empty();
    }

    private static Slot getTargetSlot(CommandContext<CommandSourceStack> context, Player targetPlayer) {
        PlayerInventory inventory = targetPlayer.getInventory();
        return BrewerCommand.getArgument(context, "equipment_slot", EquipmentSlot.class).map(equipmentSlot -> new Slot(() -> inventory.getItem(equipmentSlot), itemStack -> inventory.setItem(equipmentSlot, itemStack))).or(() -> BrewerCommand.getArgument(context, "inventory_slot", Integer.TYPE).map(inventorySlot -> new Slot(() -> inventory.getItem(inventorySlot.intValue()), itemStack -> inventory.setItem(inventorySlot.intValue(), itemStack)))).orElseGet(() -> new Slot(() -> ((PlayerInventory)inventory).getItemInMainHand(), arg_0 -> ((PlayerInventory)inventory).setItemInMainHand(arg_0)));
    }

    private static List<OfflinePlayer> getBrewers(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        try {
            return ((OfflinePlayerSelectorArgumentResolver)context.getArgument("brewers", OfflinePlayerSelectorArgumentResolver.class)).resolve((CommandSourceStack)context.getSource());
        }
        catch (IllegalArgumentException e) {
            return List.of();
        }
    }

    private static <T> Optional<T> getArgument(CommandContext<CommandSourceStack> context, String name, Class<T> resolver) {
        try {
            return Optional.of(context.getArgument(name, resolver));
        }
        catch (IllegalArgumentException e) {
            return Optional.empty();
        }
    }

    private static String getName(OfflinePlayer player) {
        String name = player.getName();
        if (name != null) {
            return name;
        }
        return player.getUniqueId().toString();
    }

    private static /* synthetic */ void lambda$command$1(ArgumentBuilder withNamedSlot, ArgumentBuilder withIndex, ArgumentBuilder argument) {
        argument.then(withNamedSlot);
        argument.then(withIndex);
        BrewerCommand.appendBrewerModification(argument);
    }

    private record Slot(Supplier<ItemStack> itemGetter, Consumer<ItemStack> itemSetter) {
    }
}

