/*
 * Decompiled with CFR 0.152.
 */
package dev.jsinco.brewery.bukkit.breweries.distillery;

import dev.jsinco.brewery.api.brew.Brew;
import dev.jsinco.brewery.api.brew.BrewingStep;
import dev.jsinco.brewery.api.breweries.Distillery;
import dev.jsinco.brewery.api.breweries.DistilleryAccess;
import dev.jsinco.brewery.api.structure.MaterialTag;
import dev.jsinco.brewery.api.structure.StructureMeta;
import dev.jsinco.brewery.api.util.CancelState;
import dev.jsinco.brewery.api.util.Holder;
import dev.jsinco.brewery.api.util.HolderProviderHolder;
import dev.jsinco.brewery.api.util.Logger;
import dev.jsinco.brewery.api.util.Pair;
import dev.jsinco.brewery.api.vector.BreweryLocation;
import dev.jsinco.brewery.brew.DistillStepImpl;
import dev.jsinco.brewery.bukkit.TheBrewingProject;
import dev.jsinco.brewery.bukkit.api.BukkitAdapter;
import dev.jsinco.brewery.bukkit.api.event.process.BrewDistillEvent;
import dev.jsinco.brewery.bukkit.brew.BrewAdapter;
import dev.jsinco.brewery.bukkit.breweries.BrewInventoryImpl;
import dev.jsinco.brewery.bukkit.breweries.distillery.BukkitDistilleryDataType;
import dev.jsinco.brewery.bukkit.breweries.distillery.DistilleryBrewPersistenceHandler;
import dev.jsinco.brewery.bukkit.structure.BreweryStructure;
import dev.jsinco.brewery.bukkit.structure.PlacedBreweryStructure;
import dev.jsinco.brewery.bukkit.util.BlockUtil;
import dev.jsinco.brewery.bukkit.util.LocationUtil;
import dev.jsinco.brewery.bukkit.util.SoundPlayer;
import dev.jsinco.brewery.bukkit.util.VectorUtil;
import dev.jsinco.brewery.configuration.Config;
import dev.jsinco.brewery.database.PersistenceException;
import dev.jsinco.brewery.util.MessageUtil;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.sound.Sound;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.bukkit.Bukkit;
import org.bukkit.Color;
import org.bukkit.Particle;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3i;

public class BukkitDistillery
implements Distillery<BukkitDistillery, ItemStack, Inventory>,
DistilleryAccess {
    private final PlacedBreweryStructure<BukkitDistillery> structure;
    private long startTime;
    private final BrewInventoryImpl mixture;
    private final BrewInventoryImpl distillate;
    private boolean dirty = true;
    private final Set<BreweryLocation> mixtureContainerLocations = new HashSet<BreweryLocation>();
    private final Set<BreweryLocation> distillateContainerLocations = new HashSet<BreweryLocation>();
    private long recentlyAccessed = -1L;

    public BukkitDistillery(@NotNull PlacedBreweryStructure<BukkitDistillery> structure) {
        this(structure, TheBrewingProject.getInstance().getTime());
    }

    public BukkitDistillery(@NotNull PlacedBreweryStructure<BukkitDistillery> structure, long startTime) {
        this.structure = structure;
        this.startTime = startTime;
        BreweryLocation unique = structure.getUnique();
        this.mixture = new BrewInventoryImpl((Component)Component.translatable((String)"tbp.distillery.gui-title.mixture"), structure.getStructure().getMeta(StructureMeta.INVENTORY_SIZE), new DistilleryBrewPersistenceHandler(unique, false));
        this.distillate = new BrewInventoryImpl((Component)Component.translatable((String)"tbp.distillery.gui-title.distillate"), structure.getStructure().getMeta(StructureMeta.INVENTORY_SIZE), new DistilleryBrewPersistenceHandler(unique, true));
    }

    @Override
    public CancelState open(@NotNull BreweryLocation location, @NotNull Holder.Player playerHolder) {
        this.checkDirty();
        Player player = BukkitAdapter.toPlayer(playerHolder).orElse(null);
        if (player == null) {
            return new CancelState.Cancelled();
        }
        if (this.mixtureContainerLocations.contains(location)) {
            this.playInteractionEffects(location, player);
            return this.openInventory(this.mixture, player);
        }
        if (this.distillateContainerLocations.contains(location)) {
            this.playInteractionEffects(location, player);
            return this.openInventory(this.distillate, player);
        }
        return new CancelState.Cancelled();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean open(@NotNull BreweryLocation breweryLocation, @NotNull UUID playerUuid) {
        CancelState cancelState;
        Optional<Holder.Player> playerHolder = HolderProviderHolder.instance().player(playerUuid);
        CancelState cancelState2 = cancelState = playerHolder.map(player -> this.open(breweryLocation, (Holder.Player)player)).orElseGet(CancelState.Cancelled::new);
        Objects.requireNonNull(cancelState2);
        CancelState cancelState3 = cancelState2;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{CancelState.Cancelled.class, CancelState.Allowed.class, CancelState.PermissionDenied.class}, (Object)cancelState3, n)) {
            default: {
                throw new MatchException(null, null);
            }
            case 0: {
                CancelState.Cancelled ignored = (CancelState.Cancelled)cancelState3;
                return false;
            }
            case 1: {
                CancelState.Allowed ignored = (CancelState.Allowed)cancelState3;
                return true;
            }
            case 2: 
        }
        CancelState.PermissionDenied permissionDenied = (CancelState.PermissionDenied)cancelState3;
        try {
            Component component;
            Component message = component = permissionDenied.message();
            playerHolder.flatMap(BukkitAdapter::toPlayer).ifPresent(player -> player.sendMessage(message));
            return false;
        }
        catch (Throwable throwable) {
            throw new MatchException(throwable.toString(), throwable);
        }
    }

    @Override
    public void close(boolean silent) {
        Stream.of(this.mixture, this.distillate).forEach(inventory -> {
            inventory.updateBrewsFromInventory();
            inventory.getInventory().clear();
        });
    }

    private void playInteractionEffects(BreweryLocation location, Player player) {
        BukkitAdapter.toWorld(location).ifPresent(world -> SoundPlayer.playSoundEffect(Config.config().sounds().distilleryAccess(), Sound.Source.BLOCK, world, (double)location.x() + 0.5, (double)location.y() + 0.5, (double)location.z() + 0.5));
        BlockUtil.playWobbleEffect(location, player);
    }

    private CancelState openInventory(BrewInventoryImpl inventory, Player player) {
        if (!player.hasPermission("brewery.distillery.access")) {
            return new CancelState.PermissionDenied((Component)Component.translatable((String)"tbp.distillery.access-denied"));
        }
        if (this.inventoryUnpopulated()) {
            this.mixture.updateInventoryFromBrews();
            this.distillate.updateInventoryFromBrews();
        }
        this.recentlyAccessed = TheBrewingProject.getInstance().getTime();
        TheBrewingProject.getInstance().getBreweryRegistry().registerOpened(this);
        player.openInventory(inventory.getInventory());
        return new CancelState.Allowed();
    }

    @Override
    public boolean inventoryAllows(@NotNull UUID playerUuid, @NotNull ItemStack item) {
        Player player = Bukkit.getPlayer((UUID)playerUuid);
        if (player == null) {
            return false;
        }
        if (!player.hasPermission("brewery.distillery.access")) {
            MessageUtil.message((Audience)player, "tbp.distillery.access-denied", new TagResolver[0]);
            return false;
        }
        return this.inventoryAllows(item);
    }

    @Override
    public boolean inventoryAllows(@NotNull ItemStack item) {
        return BrewAdapter.fromItem(item).isPresent();
    }

    @Override
    public Set<Inventory> getInventories() {
        return Set.of(this.mixture.getInventory(), this.distillate.getInventory());
    }

    private void checkDirty() {
        if (!this.dirty) {
            return;
        }
        this.dirty = false;
        BreweryStructure breweryStructure = this.structure.getStructure();
        if (breweryStructure.hasMeta(StructureMeta.DISTILLATE_MATERIAL_TAG)) {
            MaterialTag distillateMaterialTag = breweryStructure.getMeta(StructureMeta.DISTILLATE_MATERIAL_TAG);
            if (breweryStructure.hasMeta(StructureMeta.MIXTURE_MATERIAL_TAG)) {
                MaterialTag mixtureMaterialTag = breweryStructure.getMeta(StructureMeta.MIXTURE_MATERIAL_TAG);
                if (mixtureMaterialTag.volume() > distillateMaterialTag.volume()) {
                    List<BreweryLocation> mixturePositions = this.findMaterialRegion(mixtureMaterialTag, List.of());
                    this.mixtureContainerLocations.addAll(mixturePositions);
                    this.distillateContainerLocations.addAll(this.findMaterialRegion(distillateMaterialTag, mixturePositions));
                } else {
                    List<BreweryLocation> distillatePositions = this.findMaterialRegion(distillateMaterialTag, List.of());
                    this.distillateContainerLocations.addAll(distillatePositions);
                    this.mixtureContainerLocations.addAll(this.findMaterialRegion(mixtureMaterialTag, distillatePositions));
                }
                return;
            }
            this.distillateContainerLocations.addAll(this.findMaterialRegion(distillateMaterialTag, List.of()));
        }
        if (breweryStructure.hasMeta(StructureMeta.MIXTURE_MATERIAL_TAG)) {
            MaterialTag mixtureMaterialTag = breweryStructure.getMeta(StructureMeta.MIXTURE_MATERIAL_TAG);
            this.mixtureContainerLocations.addAll(this.findMaterialRegion(mixtureMaterialTag, List.of()));
        }
        BreweryLocation worldOrigin = BukkitAdapter.toBreweryLocation(this.structure.getWorldOrigin());
        if (breweryStructure.hasMeta(StructureMeta.DISTILLATE_ACCESS_POINTS)) {
            breweryStructure.getMeta(StructureMeta.DISTILLATE_ACCESS_POINTS).elements().stream().map(VectorUtil::toJoml).map(vector -> VectorUtil.transform(vector, this.structure.getTransformation())).map(VectorUtil::toBreweryVector).map(worldOrigin::add).forEach(this.distillateContainerLocations::add);
        }
        if (breweryStructure.hasMeta(StructureMeta.MIXTURE_ACCESS_POINTS)) {
            breweryStructure.getMeta(StructureMeta.MIXTURE_ACCESS_POINTS).elements().stream().map(VectorUtil::toJoml).map(vector -> VectorUtil.transform(vector, this.structure.getTransformation())).map(VectorUtil::toBreweryVector).map(worldOrigin::add).forEach(this.mixtureContainerLocations::add);
        }
    }

    private List<BreweryLocation> findMaterialRegion(MaterialTag tag, List<BreweryLocation> blackList) {
        Set materials = tag.materials().stream().map(BukkitAdapter::toMaterial).collect(Collectors.toSet());
        List<BreweryLocation> matchingPositions = this.structure.positions().stream().map(BukkitAdapter::toBlock).flatMap(Optional::stream).filter(block -> materials.contains(block.getType())).map(BukkitAdapter::toBreweryLocation).toList();
        ArrayList<BreweryLocation> output = new ArrayList<BreweryLocation>();
        Vector3i region = new Vector3i(tag.xRegion(), tag.yRegion(), tag.zRegion());
        Vector3i transformedRegion = VectorUtil.transform(region, this.structure.getTransformation());
        for (BreweryLocation matchingPosition : matchingPositions) {
            List<BreweryLocation> found = this.findInSelection(matchingPosition, transformedRegion, matchingPositions);
            if (blackList.stream().anyMatch(found::contains)) continue;
            output.addAll(found);
        }
        return output;
    }

    private List<BreweryLocation> findInSelection(BreweryLocation startingPoint, Vector3i region, List<BreweryLocation> matchingPositions) {
        ArrayList<BreweryLocation> output = new ArrayList<BreweryLocation>();
        for (int dx = 0; dx < Math.abs(region.x()); ++dx) {
            for (int dy = 0; dy < Math.abs(region.y()); ++dy) {
                for (int dz = 0; dz < Math.abs(region.z()); ++dz) {
                    BreweryLocation relative = startingPoint.add(dx, dy, dz);
                    if (!matchingPositions.contains(relative)) {
                        return List.of();
                    }
                    output.add(relative);
                }
            }
        }
        return output;
    }

    private boolean shouldUnpopulateInventory() {
        return this.recentlyAccessed == -1L || this.recentlyAccessed + 20L <= TheBrewingProject.getInstance().getTime();
    }

    private boolean inventoryUnpopulated() {
        return this.recentlyAccessed == -1L;
    }

    @Override
    public void tick() {
        long particleEffectInterval;
        BreweryLocation unique = ((PlacedBreweryStructure)this.getStructure()).getUnique();
        long timeProcessed = this.getTimeProcessed();
        long processTime = this.getProcessTime();
        int processedBrews = (int)(timeProcessed / processTime * (long)((PlacedBreweryStructure)this.getStructure()).getStructure().getMeta(StructureMeta.PROCESS_AMOUNT).intValue());
        if (!BlockUtil.isChunkLoaded(unique) || this.mixture.brewAmount() < processedBrews || this.distillate.isFull()) {
            return;
        }
        this.checkDirty();
        if (timeProcessed % processTime == 0L && timeProcessed != 0L) {
            BukkitAdapter.toWorld(unique).ifPresent(world -> SoundPlayer.playSoundEffect(Config.config().sounds().distilleryProcess(), Sound.Source.BLOCK, world, (double)unique.x() + 0.5, (double)unique.y() + 0.5, (double)unique.z() + 0.5));
        }
        if (timeProcessed % (particleEffectInterval = Math.max(processTime / 4L, 10L)) < 5L && this.mixture.brewAmount() > processedBrews) {
            this.distillateContainerLocations.stream().map(BukkitAdapter::toLocation).flatMap(Optional::stream).map(location -> location.add(0.5, 1.3, 0.5)).forEach(location -> location.getWorld().spawnParticle(Particle.ENTITY_EFFECT, location, 2, (Object)Color.WHITE));
        }
    }

    @Override
    public void tickInventory() {
        long processTime;
        long timeProcessed;
        this.checkDirty();
        if (this.shouldUnpopulateInventory()) {
            this.close(false);
            TheBrewingProject.getInstance().getBreweryRegistry().unregisterOpened(this);
            this.recentlyAccessed = -1L;
            return;
        }
        if (!this.mixture.getInventory().getViewers().isEmpty() || !this.distillate.getInventory().getViewers().isEmpty()) {
            this.recentlyAccessed = TheBrewingProject.getInstance().getTime();
        }
        if ((timeProcessed = this.getTimeProcessed()) < (processTime = this.getProcessTime()) - 1L || this.mixture.getInventory().isEmpty()) {
            return;
        }
        boolean hasChanged = this.mixture.updateBrewsFromInventory();
        this.distillate.updateBrewsFromInventory();
        if (hasChanged) {
            this.resetStartTime();
            return;
        }
        if (timeProcessed < processTime) {
            return;
        }
        this.transferItems(this.mixture, this.distillate, (int)((long)((PlacedBreweryStructure)this.getStructure()).getStructure().getMeta(StructureMeta.PROCESS_AMOUNT).intValue() * (timeProcessed / processTime)));
        this.distillate.updateInventoryFromBrews();
        this.mixture.updateInventoryFromBrews();
        this.resetStartTime();
    }

    @Override
    public Optional<Inventory> access(@NotNull BreweryLocation breweryLocation) {
        if (this.inventoryUnpopulated() && (this.mixtureContainerLocations.contains(breweryLocation) || this.distillateContainerLocations.contains(breweryLocation))) {
            this.mixture.updateInventoryFromBrews();
            this.distillate.updateInventoryFromBrews();
            TheBrewingProject.getInstance().getBreweryRegistry().registerOpened(this);
        }
        this.recentlyAccessed = TheBrewingProject.getInstance().getTime();
        if (this.mixtureContainerLocations.contains(breweryLocation)) {
            return Optional.of(this.mixture.getInventory());
        }
        if (this.distillateContainerLocations.contains(breweryLocation)) {
            return Optional.of(this.distillate.getInventory());
        }
        return Optional.empty();
    }

    @Override
    public Brew initializeBrew(Brew brew) {
        if (brew.lastStep() instanceof BrewingStep.Distill) {
            return brew;
        }
        return brew.withStep(new DistillStepImpl(0));
    }

    private long getTimeProcessed() {
        return TheBrewingProject.getInstance().getTime() - this.startTime;
    }

    private void resetStartTime() {
        this.startTime = TheBrewingProject.getInstance().getTime();
        try {
            TheBrewingProject.getInstance().getDatabase().updateValue(BukkitDistilleryDataType.INSTANCE, this);
        }
        catch (PersistenceException e) {
            Logger.logErr(e);
        }
    }

    private long getProcessTime() {
        return ((PlacedBreweryStructure)this.getStructure()).getStructure().getMeta(StructureMeta.PROCESS_TIME);
    }

    private void transferItems(BrewInventoryImpl inventory1, BrewInventoryImpl inventory2, int amount) {
        int i;
        LinkedList<Pair<Brew, Integer>> brewsToTransfer = new LinkedList<Pair<Brew, Integer>>();
        for (i = 0; i < inventory1.getBrews().length; ++i) {
            if (inventory1.getBrews()[i] == null) continue;
            if (amount-- <= 0) break;
            brewsToTransfer.add(new Pair<Brew, Integer>(inventory1.getBrews()[i], i));
        }
        for (i = 0; i < inventory2.getBrews().length; ++i) {
            Brew distillateBrew;
            if (inventory2.getBrews()[i] != null) continue;
            if (brewsToTransfer.isEmpty()) {
                return;
            }
            Pair nextBrewToTransfer = (Pair)brewsToTransfer.poll();
            Brew mixtureBrew = (Brew)nextBrewToTransfer.first();
            BrewDistillEvent event = new BrewDistillEvent(this, mixtureBrew, distillateBrew = mixtureBrew.withLastStep(BrewingStep.Distill.class, BrewingStep.Distill::incrementRuns, () -> new DistillStepImpl(1)));
            if (!event.callEvent()) continue;
            inventory1.store(null, (Integer)nextBrewToTransfer.second());
            inventory2.store(event.getResult(), i);
        }
    }

    public List<Brew> calculateDestroyDrops() {
        ArrayList<Brew> drops = new ArrayList<Brew>();
        boolean inventoryUnpopulated = this.inventoryUnpopulated();
        for (BrewInventoryImpl distilleryInventory : List.of(this.distillate, this.mixture)) {
            if (!inventoryUnpopulated) {
                distilleryInventory.updateBrewsFromInventory();
            }
            drops.addAll(distilleryInventory.getBrewSnapshot());
        }
        return drops;
    }

    public void destroyWithoutDrops() {
        this.distillate.destroy();
        this.mixture.destroy();
    }

    @Override
    public void destroy(BreweryLocation breweryLocation) {
        this.calculateDestroyDrops();
        ArrayList<Brew> drops = new ArrayList<Brew>();
        drops.addAll(this.distillate.destroy());
        drops.addAll(this.mixture.destroy());
        LocationUtil.dropBrews(breweryLocation, drops);
    }

    @Override
    @Generated
    public PlacedBreweryStructure<BukkitDistillery> getStructure() {
        return this.structure;
    }

    @Override
    @Generated
    public long getStartTime() {
        return this.startTime;
    }

    @Override
    @Generated
    public BrewInventoryImpl getMixture() {
        return this.mixture;
    }

    @Override
    @Generated
    public BrewInventoryImpl getDistillate() {
        return this.distillate;
    }
}

