/*
 * Decompiled with CFR 0.152.
 */
package dev.jsinco.brewery.bukkit.breweries;

import dev.jsinco.brewery.api.brew.Brew;
import dev.jsinco.brewery.api.breweries.BrewInventory;
import dev.jsinco.brewery.bukkit.brew.BrewAdapter;
import dev.jsinco.brewery.bukkit.breweries.BrewPersistenceHandler;
import java.util.List;
import java.util.Objects;
import lombok.Generated;
import net.kyori.adventure.text.Component;
import org.bukkit.Bukkit;
import org.bukkit.entity.HumanEntity;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BrewInventoryImpl
implements InventoryHolder,
BrewInventory {
    private final Inventory inventory;
    private final Brew[] brews;
    private final BrewPersistenceHandler store;

    public BrewInventoryImpl(Component title, int size, BrewPersistenceHandler store) {
        this.inventory = Bukkit.createInventory((InventoryHolder)this, (int)size, (Component)title);
        this.brews = new Brew[size];
        this.store = store;
    }

    @NotNull
    public Inventory getInventory() {
        return this.inventory;
    }

    @Override
    public void set(@Nullable Brew brew, int position) {
        this.brews[position] = brew;
    }

    @Override
    public void updateInventoryFromBrews() {
        for (int i = 0; i < this.brews.length; ++i) {
            Brew brew = this.brews[i];
            if (brew == null) {
                this.inventory.setItem(i, null);
                continue;
            }
            this.inventory.setItem(i, BrewAdapter.toItem(brew, new Brew.State.Brewing()));
        }
    }

    @Override
    public boolean updateBrewsFromInventory() {
        boolean hasUpdated = false;
        for (int i = 0; i < this.inventory.getSize(); ++i) {
            ItemStack itemStack = this.inventory.getItem(i);
            Brew brew = itemStack == null ? null : (Brew)BrewAdapter.fromItem(itemStack).orElse(null);
            if (!Objects.equals(brew, this.brews[i])) {
                hasUpdated = true;
            }
            this.store(brew, i);
        }
        return hasUpdated;
    }

    @Override
    public void store(Brew brew, int position) {
        this.store.store(brew, position, this);
        this.set(brew, position);
    }

    @Override
    public boolean isEmpty() {
        for (Brew brew : this.brews) {
            if (brew == null) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isFull() {
        for (Brew brew : this.brews) {
            if (brew != null) continue;
            return false;
        }
        return true;
    }

    @Override
    public int brewAmount() {
        int amount = 0;
        for (Brew brew : this.brews) {
            if (brew == null) continue;
            ++amount;
        }
        return amount;
    }

    public List<Brew> destroy() {
        List.copyOf(this.inventory.getViewers()).forEach(HumanEntity::closeInventory);
        this.inventory.clear();
        return this.getBrewSnapshot();
    }

    @Override
    @Generated
    public Brew[] getBrews() {
        return this.brews;
    }
}

