/*
 * Decompiled with CFR 0.152.
 */
package dev.jsinco.brewery.bukkit.api.event.transaction;

import com.google.common.base.Preconditions;
import dev.jsinco.brewery.api.breweries.Cauldron;
import dev.jsinco.brewery.api.util.CancelState;
import dev.jsinco.brewery.bukkit.api.event.PermissibleBreweryEvent;
import dev.jsinco.brewery.bukkit.api.transaction.ItemSource;
import lombok.Generated;
import org.bukkit.entity.Player;
import org.bukkit.event.HandlerList;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CauldronInsertEvent
extends PermissibleBreweryEvent {
    private static final HandlerList HANDLERS = new HandlerList();
    private final Cauldron cauldron;
    private ItemSource.ItemBasedSource itemSource;
    @Nullable
    private final Player player;

    public CauldronInsertEvent(Cauldron cauldron, ItemSource.ItemBasedSource itemSource, @NotNull CancelState state, @Nullable Player player) {
        super(state);
        this.cauldron = cauldron;
        this.itemSource = itemSource;
        this.player = player;
    }

    public void setResult(@NotNull ItemStack item) {
        Preconditions.checkNotNull((Object)item);
        this.itemSource = new ItemSource.ItemBasedSource(item.clone());
    }

    @NotNull
    public HandlerList getHandlers() {
        return HANDLERS;
    }

    public static HandlerList getHandlerList() {
        return HANDLERS;
    }

    @Generated
    public Cauldron getCauldron() {
        return this.cauldron;
    }

    @Generated
    public ItemSource.ItemBasedSource getItemSource() {
        return this.itemSource;
    }

    @Nullable
    @Generated
    public Player getPlayer() {
        return this.player;
    }
}

