/*
 * Decompiled with CFR 0.152.
 */
package dev.jsinco.brewery.brew;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import dev.jsinco.brewery.api.brew.Brew;
import dev.jsinco.brewery.api.brew.BrewingStep;
import dev.jsinco.brewery.api.ingredient.IngredientManager;
import dev.jsinco.brewery.api.meta.MetaData;
import dev.jsinco.brewery.brew.BrewImpl;
import dev.jsinco.brewery.brew.BrewingStepSerializer;
import dev.jsinco.brewery.meta.MetaSerializer;
import dev.jsinco.brewery.util.FutureUtil;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.jetbrains.annotations.Nullable;

public class BrewSerializer {
    public static final BrewSerializer INSTANCE = new BrewSerializer();
    private static final int VERSION = 1;

    public JsonElement serialize(Brew brew, IngredientManager<?> ingredientManager) {
        JsonObject obj = new JsonObject();
        obj.addProperty("version", 1);
        obj.add("steps", BrewSerializer.steps(brew, ingredientManager));
        obj.add("meta", MetaSerializer.INSTANCE.serialize(brew.meta()));
        return obj;
    }

    private static JsonArray steps(Brew brew, IngredientManager<?> ingredientManager) {
        JsonArray array = new JsonArray();
        for (BrewingStep step : brew.getSteps()) {
            array.add(BrewingStepSerializer.INSTANCE.serialize(step, ingredientManager));
        }
        return array;
    }

    public CompletableFuture<Brew> deserialize(JsonElement jsonElement, IngredientManager<?> ingredientManager) {
        int version;
        if (jsonElement.isJsonArray()) {
            return BrewSerializer.deserializeVersion0(jsonElement, ingredientManager);
        }
        JsonObject jsonObject = jsonElement.getAsJsonObject();
        int n = version = jsonObject.has("version") ? jsonObject.get("version").getAsInt() : 0;
        if (version < 1 || version > 1) {
            throw new RuntimeException("Unsupported version: " + version);
        }
        return BrewSerializer.getSteps(jsonObject.getAsJsonArray("steps"), ingredientManager).thenApplyAsync(steps -> new BrewImpl((List<BrewingStep>)steps, BrewSerializer.getMeta(jsonObject.getAsJsonObject("meta"))));
    }

    private static CompletableFuture<Brew> deserializeVersion0(JsonElement jsonElement, IngredientManager<?> ingredientManager) {
        return BrewSerializer.getSteps(jsonElement.getAsJsonArray(), ingredientManager).thenApplyAsync(BrewImpl::new);
    }

    private static CompletableFuture<List<BrewingStep>> getSteps(@Nullable JsonArray jsonArray, IngredientManager<?> ingredientManager) {
        if (jsonArray == null) {
            return CompletableFuture.completedFuture(List.of());
        }
        List brewingStepFutures = jsonArray.asList().stream().map(element -> BrewingStepSerializer.INSTANCE.deserialize((JsonElement)element, ingredientManager)).toList();
        return FutureUtil.mergeFutures(brewingStepFutures);
    }

    private static MetaData getMeta(@Nullable JsonObject jsonObject) {
        if (jsonObject == null) {
            return new MetaData();
        }
        return MetaSerializer.INSTANCE.deserialize(jsonObject);
    }
}

