/*
 * Decompiled with CFR 0.152.
 */
package dev.jsinco.brewery.brew;

import dev.jsinco.brewery.api.brew.Brew;
import dev.jsinco.brewery.api.brew.BrewQuality;
import dev.jsinco.brewery.api.brew.BrewScore;
import dev.jsinco.brewery.api.brew.BrewingStep;
import dev.jsinco.brewery.api.brew.PartialBrewScore;
import dev.jsinco.brewery.api.brew.ScoreType;
import dev.jsinco.brewery.api.meta.MetaData;
import dev.jsinco.brewery.api.meta.MetaDataType;
import dev.jsinco.brewery.api.recipe.Recipe;
import dev.jsinco.brewery.api.recipe.RecipeRegistry;
import dev.jsinco.brewery.brew.BrewSerializer;
import dev.jsinco.brewery.recipes.BrewScoreImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.SequencedSet;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import net.kyori.adventure.key.Key;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BrewImpl
implements Brew {
    private final List<BrewingStep> steps;
    private final MetaData meta;
    public static final BrewSerializer SERIALIZER = new BrewSerializer();

    public BrewImpl(BrewingStep.Cook cook) {
        this(List.of(cook));
    }

    public BrewImpl(BrewingStep.Mix mix) {
        this(List.of(mix));
    }

    public BrewImpl(@NotNull List<BrewingStep> steps) {
        this(steps, new MetaData());
    }

    public BrewImpl(List<BrewingStep> steps, MetaData meta) {
        this.steps = steps;
        this.meta = meta;
    }

    @Override
    public BrewImpl withStep(BrewingStep step) {
        return new BrewImpl(Stream.concat(this.steps.stream().filter(BrewingStep::isCompleted), Stream.of(step)).toList(), this.meta);
    }

    @Override
    public BrewImpl withSteps(Collection<BrewingStep> steps) {
        return new BrewImpl(Stream.concat(this.steps.stream().filter(BrewingStep::isCompleted), steps.stream()).toList(), this.meta);
    }

    @Override
    public BrewImpl withStepsReplaced(Collection<BrewingStep> steps) {
        return new BrewImpl(List.copyOf(steps), this.meta);
    }

    @Override
    public BrewImpl withModifiedStep(int index, Function<BrewingStep, BrewingStep> modifier) {
        BrewingStep newStep = modifier.apply(this.steps.get(index));
        return new BrewImpl(Stream.concat(this.steps.subList(0, this.steps.size() - 1).stream(), Stream.of(newStep)).toList(), this.meta);
    }

    @Override
    public BrewImpl witModifiedLastStep(Function<BrewingStep, BrewingStep> modifier) {
        BrewingStep newStep = modifier.apply(this.steps.getLast());
        return new BrewImpl(Stream.concat(this.steps.subList(0, this.steps.size() - 1).stream(), Stream.of(newStep)).toList(), this.meta);
    }

    @Override
    public <B extends BrewingStep> Brew withModifiedLastStep(Class<B> bClass, Function<B, B> modifier) {
        if (!this.steps.isEmpty() && bClass.isInstance(this.lastStep())) {
            return this.witModifiedLastStep(modifier);
        }
        return this;
    }

    @Override
    public <B extends BrewingStep> BrewImpl withLastStep(Class<B> bClass, Function<B, B> modifier, Supplier<B> stepSupplier) {
        if (!this.steps.isEmpty() && bClass.isInstance(this.lastStep())) {
            BrewingStep newStep = (BrewingStep)modifier.apply((BrewingStep)bClass.cast(this.lastStep()));
            return new BrewImpl(Stream.concat(this.steps.subList(0, this.steps.size() - 1).stream(), Stream.of(newStep)).toList(), this.meta);
        }
        return this.withStep((BrewingStep)stepSupplier.get());
    }

    @Override
    public List<BrewingStep> getCompletedSteps() {
        return this.steps.stream().filter(BrewingStep::isCompleted).toList();
    }

    @Override
    public SequencedSet<UUID> getBrewers() {
        return this.steps.stream().filter(BrewingStep::isCompleted).map(BrewingStep::brewers).flatMap(Collection::stream).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    @Override
    public Optional<UUID> leadBrewer() {
        HashMap scores = new HashMap();
        this.steps.stream().filter(BrewingStep::isCompleted).map(BrewingStep::brewers).flatMap(Collection::stream).forEach(uuid -> scores.compute(uuid, (ignored, value) -> value == null ? 1 : value + 1));
        return scores.entrySet().stream().max(Map.Entry.comparingByValue()).map(Map.Entry::getKey);
    }

    @Override
    public int stepAmount() {
        return this.steps.size();
    }

    @Override
    public <P, C> Brew withMeta(Key key, MetaDataType<P, C> type, C value) {
        return new BrewImpl(this.steps, (MetaData)this.meta.withMeta(key, (MetaDataType)type, (Object)value));
    }

    @Override
    public Brew withoutMeta(Key key) {
        return new BrewImpl(this.steps, this.meta.withoutMeta(key));
    }

    @Override
    public MetaData meta() {
        return this.meta;
    }

    @Override
    @Nullable
    public <P, C> C meta(Key key, MetaDataType<P, C> type) {
        return this.meta.meta(key, type);
    }

    @Override
    public <P, C> boolean hasMeta(Key key, MetaDataType<P, C> type) {
        return this.meta.hasMeta(key, type);
    }

    @Override
    public Set<Key> metaKeys() {
        return this.meta.metaKeys();
    }

    @Override
    public <I> Optional<Recipe<I>> closestRecipe(RecipeRegistry<I> registry) {
        double bestScore = 0.0;
        Recipe<I> bestMatch = null;
        for (Recipe<I> recipe : registry.getRecipes()) {
            double score = this.score(recipe).rawScore();
            if (!(score > bestScore)) continue;
            bestScore = score;
            bestMatch = recipe;
        }
        return Optional.ofNullable(bestMatch);
    }

    @Override
    @NotNull
    public BrewScore score(Recipe<?> recipe) {
        List<BrewingStep> recipeSteps = recipe.getSteps();
        ArrayList<Map<ScoreType, PartialBrewScore>> scores = new ArrayList<Map<ScoreType, PartialBrewScore>>();
        List<BrewingStep> completedSteps = this.getCompletedSteps();
        if (completedSteps.size() > recipeSteps.size()) {
            return BrewScoreImpl.failed(this);
        }
        for (int i = 0; i < completedSteps.size(); ++i) {
            BrewingStep recipeStep = recipeSteps.get(i);
            scores.add(recipeStep.proximityScores(completedSteps.get(i)));
        }
        boolean completed = completedSteps.size() == recipeSteps.size();
        BrewScoreImpl brewScore = new BrewScoreImpl(scores, completed, recipe.getBrewDifficulty());
        if (brewScore.brewQuality() == null) {
            scores.removeLast();
            scores.add(recipeSteps.get(completedSteps.size() - 1).maximumScores(completedSteps.getLast()));
            BrewScoreImpl uncompleted = new BrewScoreImpl(scores, false, recipe.getBrewDifficulty());
            if (uncompleted.brewQuality() != null) {
                return uncompleted;
            }
        }
        return brewScore;
    }

    @Override
    public Optional<BrewQuality> quality(Recipe<?> recipe) {
        return Optional.ofNullable(this.score(recipe).brewQuality());
    }

    @Override
    @NotNull
    public BrewingStep lastCompletedStep() {
        for (int i = this.steps.size() - 1; i >= 0; --i) {
            BrewingStep step = this.steps.get(i);
            if (!step.isCompleted()) continue;
            return step;
        }
        throw new IndexOutOfBoundsException();
    }

    @Override
    @NotNull
    public BrewingStep lastStep() {
        return this.steps.getLast();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        BrewImpl brew = (BrewImpl)other;
        return this.steps.equals(brew.steps);
    }

    public String toString() {
        return "BrewImpl{steps=" + String.valueOf(this.steps) + ", meta=" + String.valueOf(this.meta) + "}";
    }

    @Override
    @Generated
    public List<BrewingStep> getSteps() {
        return this.steps;
    }
}

