/*
 * Decompiled with CFR 0.152.
 */
package dev.jsinco.brewery.api.recipe;

import com.google.common.base.Preconditions;
import dev.jsinco.brewery.api.brew.BrewQuality;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class QualityData<T> {
    private final Map<BrewQuality, T> backing;
    private static final Pattern TAG_PATTERN = Pattern.compile("^[!?#]?[a-z0-9_-]*>|^[!?#]?[a-z0-9_-]*:.*>");

    private QualityData(Map<BrewQuality, T> backing) {
        this.backing = backing;
    }

    public static <T> QualityData<T> equalValued(T t) {
        return new QualityData<Object>(Arrays.stream(BrewQuality.values()).collect(Collectors.toMap(quality -> quality, ignored -> t)));
    }

    public <U> QualityData<U> map(Function<T, U> mapper) {
        HashMap<BrewQuality, Object> newBacking = new HashMap<BrewQuality, Object>();
        for (Map.Entry<BrewQuality, T> entry : this.backing.entrySet()) {
            newBacking.put(entry.getKey(), Preconditions.checkNotNull(mapper.apply(entry.getValue())));
        }
        return new QualityData(newBacking);
    }

    public <U> QualityData<U> map(U defaultValue, Function<T, U> mapper) {
        HashMap<BrewQuality, Object> newBacking = new HashMap<BrewQuality, Object>();
        for (Map.Entry<BrewQuality, T> entry : this.backing.entrySet()) {
            try {
                newBacking.put(entry.getKey(), Preconditions.checkNotNull(mapper.apply(entry.getValue())));
            }
            catch (Throwable throwable) {
                newBacking.put(entry.getKey(), defaultValue);
            }
        }
        return new QualityData(newBacking);
    }

    @NotNull
    public T get(BrewQuality brewQuality) {
        return this.backing.get((Object)brewQuality);
    }

    @Deprecated(forRemoval=true)
    @NotNull
    public T get(BrewQuality brewQuality, T ignored) {
        return this.backing.get((Object)brewQuality);
    }

    public static <T> QualityData<T> fromValueMapper(Function<BrewQuality, T> mapper) {
        return new QualityData<T>(Arrays.stream(BrewQuality.values()).collect(Collectors.toMap(quality -> quality, mapper)));
    }

    public static QualityData<String> readQualityFactoredString(@NotNull String string) {
        String[] list = QualityData.split(string);
        if (list.length == 1) {
            return new QualityData<String>(Map.of(BrewQuality.BAD, string, BrewQuality.GOOD, string, BrewQuality.EXCELLENT, string));
        }
        if (list.length != 3) {
            throw new IllegalArgumentException("Expected a string with format <bad>/<good>/<excellent>");
        }
        HashMap<BrewQuality, String> map = new HashMap<BrewQuality, String>();
        for (int i = 0; i < 3; ++i) {
            map.put(BrewQuality.values()[i], list[i]);
        }
        return new QualityData<String>(map);
    }

    private static String[] split(String string) {
        int previous = 0;
        Stream.Builder<String> builder = Stream.builder();
        for (int i = 0; i < string.length(); ++i) {
            char character = string.charAt(i);
            if (character != '/') continue;
            if (i == 0 || i == string.length() - 1) {
                builder.add(string.substring(previous, i));
                previous = i + 1;
                continue;
            }
            if (string.charAt(i - 1) == '<' && TAG_PATTERN.matcher(string.substring(i + 1)).find()) continue;
            builder.add(string.substring(previous, i));
            previous = i + 1;
        }
        builder.add(string.substring(previous));
        return (String[])builder.build().toArray(String[]::new);
    }

    public static QualityData<List<String>> readQualityFactoredStringList(@Nullable List<String> stringList) {
        if (stringList == null) {
            return new QualityData<List<String>>(Arrays.stream(BrewQuality.values()).collect(Collectors.toMap(brewQuality -> brewQuality, ignored -> List.of())));
        }
        HashMap<BrewQuality, List> map = new HashMap<BrewQuality, List>();
        for (String string : stringList) {
            if (string.startsWith("+++")) {
                map.computeIfAbsent(BrewQuality.EXCELLENT, ignored -> new ArrayList()).add(string.substring(3));
                continue;
            }
            if (string.startsWith("++")) {
                map.computeIfAbsent(BrewQuality.GOOD, ignored -> new ArrayList()).add(string.substring(2));
                continue;
            }
            if (string.startsWith("+")) {
                map.computeIfAbsent(BrewQuality.BAD, ignored -> new ArrayList()).add(string.substring(1));
                continue;
            }
            for (BrewQuality quality : BrewQuality.values()) {
                map.computeIfAbsent(quality, ignored -> new ArrayList()).add(string);
            }
        }
        for (BrewQuality quality : BrewQuality.values()) {
            map.putIfAbsent(quality, new ArrayList());
        }
        return new QualityData<List<String>>(map);
    }

    public void forEach(BiConsumer<BrewQuality, T> consumer) {
        for (BrewQuality brewQuality : BrewQuality.values()) {
            T value = this.get(brewQuality);
            if (value == null) continue;
            consumer.accept(brewQuality, (BrewQuality)((Object)value));
        }
    }

    public <U> QualityData<U> qualityMap(BiFunction<BrewQuality, T, U> biFunction) {
        HashMap<BrewQuality, U> newBacking = new HashMap<BrewQuality, U>();
        for (Map.Entry<BrewQuality, T> entry : this.backing.entrySet()) {
            newBacking.put(entry.getKey(), biFunction.apply(entry.getKey(), (BrewQuality)((Object)entry.getValue())));
        }
        return new QualityData(newBacking);
    }

    public static String toQualityFactoredString(QualityData<String> qualityData) {
        return qualityData.get(BrewQuality.BAD) + "/" + qualityData.get(BrewQuality.GOOD) + "/" + qualityData.get(BrewQuality.EXCELLENT);
    }
}

