/*
 * Decompiled with CFR 0.152.
 */
package dev.jsinco.brewery.api.meta;

import com.google.common.base.Preconditions;
import dev.jsinco.brewery.api.meta.ListMetaDataType;
import dev.jsinco.brewery.api.meta.MetaData;
import java.util.function.Function;

public interface MetaDataType<P, C> {
    public static final MetaDataType<Byte, Byte> BYTE = new Primitive<Byte>(Byte.class);
    public static final MetaDataType<Short, Short> SHORT = new Primitive<Short>(Short.class);
    public static final MetaDataType<Integer, Integer> INTEGER = new Primitive<Integer>(Integer.class);
    public static final MetaDataType<Long, Long> LONG = new Primitive<Long>(Long.class);
    public static final MetaDataType<Float, Float> FLOAT = new Primitive<Float>(Float.class);
    public static final MetaDataType<Double, Double> DOUBLE = new Primitive<Double>(Double.class);
    public static final MetaDataType<String, String> STRING = new Primitive<String>(String.class);
    public static final MetaDataType<byte[], byte[]> BYTE_ARRAY = new Primitive<byte[]>(byte[].class);
    public static final MetaDataType<int[], int[]> INTEGER_ARRAY = new Primitive<int[]>(int[].class);
    public static final MetaDataType<long[], long[]> LONG_ARRAY = new Primitive<long[]>(long[].class);
    public static final MetaDataType<MetaData, MetaData> CONTAINER = new Primitive<MetaData>(MetaData.class);
    public static final ListMetaDataType<Byte, Byte> BYTE_LIST = ListMetaDataType.from(BYTE);
    public static final ListMetaDataType<Short, Short> SHORT_LIST = ListMetaDataType.from(SHORT);
    public static final ListMetaDataType<Integer, Integer> INTEGER_LIST = ListMetaDataType.from(INTEGER);
    public static final ListMetaDataType<Long, Long> LONG_LIST = ListMetaDataType.from(LONG);
    public static final ListMetaDataType<Float, Float> FLOAT_LIST = ListMetaDataType.from(FLOAT);
    public static final ListMetaDataType<Double, Double> DOUBLE_LIST = ListMetaDataType.from(DOUBLE);
    public static final ListMetaDataType<String, String> STRING_LIST = ListMetaDataType.from(STRING);
    public static final ListMetaDataType<byte[], byte[]> BYTE_ARRAY_LIST = ListMetaDataType.from(BYTE_ARRAY);
    public static final ListMetaDataType<int[], int[]> INTEGER_ARRAY_LIST = ListMetaDataType.from(INTEGER_ARRAY);
    public static final ListMetaDataType<long[], long[]> LONG_ARRAY_LIST = ListMetaDataType.from(LONG_ARRAY);
    public static final ListMetaDataType<MetaData, MetaData> CONTAINER_LIST = ListMetaDataType.from(CONTAINER);
    public static final MetaDataType<String, Long> STRING_TO_LONG = MetaDataType.convertedType(STRING, Long::parseLong, String::valueOf, Long.class);
    public static final MetaDataType<String, Integer> STRING_TO_INT = MetaDataType.convertedType(STRING, Integer::parseInt, String::valueOf, Integer.class);
    public static final MetaDataType<String, Byte> STRING_TO_BYTE = MetaDataType.convertedType(STRING, Byte::parseByte, String::valueOf, Byte.class);
    public static final MetaDataType<String, Short> STRING_TO_SHORT = MetaDataType.convertedType(STRING, Short::parseShort, String::valueOf, Short.class);
    public static final MetaDataType<String, Float> STRING_TO_FLOAT = MetaDataType.convertedType(STRING, Float::parseFloat, String::valueOf, Float.class);
    public static final MetaDataType<String, Double> STRING_TO_DOUBLE = MetaDataType.convertedType(STRING, Double::parseDouble, String::valueOf, Double.class);

    public Class<P> getPrimitiveType();

    public Class<C> getComplexType();

    public P toPrimitive(C var1);

    public C toComplex(P var1);

    public static <P, C, M> MetaDataType<P, C> convertedType(final MetaDataType<P, M> parent, final Function<M, C> toChild, final Function<C, M> toParent, final Class<C> childComplex) {
        return new MetaDataType<P, C>(){

            @Override
            public Class<P> getPrimitiveType() {
                return parent.getPrimitiveType();
            }

            @Override
            public Class<C> getComplexType() {
                return childComplex;
            }

            @Override
            public P toPrimitive(C complex) {
                Object middle = toParent.apply(complex);
                Preconditions.checkArgument((boolean)parent.getComplexType().isInstance(middle), (Object)("Expected value to be of type '" + String.valueOf(parent.getComplexType()) + "' was: " + String.valueOf(middle)));
                return parent.toPrimitive(middle);
            }

            @Override
            public C toComplex(P primitive) {
                Object middle = parent.toComplex(primitive);
                Preconditions.checkArgument((boolean)parent.getComplexType().isInstance(middle), (Object)("Expected value to be of type '" + String.valueOf(parent.getComplexType()) + "' was: " + String.valueOf(middle)));
                return toChild.apply(middle);
            }
        };
    }

    public static class Primitive<P>
    implements MetaDataType<P, P> {
        private final Class<P> primitiveClass;

        private Primitive(Class<P> primitiveClass) {
            this.primitiveClass = primitiveClass;
        }

        @Override
        public Class<P> getPrimitiveType() {
            return this.primitiveClass;
        }

        @Override
        public Class<P> getComplexType() {
            return this.primitiveClass;
        }

        @Override
        public P toPrimitive(P complex) {
            return complex;
        }

        @Override
        public P toComplex(P primitive) {
            return primitive;
        }
    }
}

