/*
 * Decompiled with CFR 0.152.
 */
package dev.jsinco.brewery.api.meta;

import com.google.errorprone.annotations.Immutable;
import dev.jsinco.brewery.api.meta.ListMetaDataType;
import dev.jsinco.brewery.api.meta.MetaContainer;
import dev.jsinco.brewery.api.meta.MetaDataType;
import java.lang.runtime.SwitchBootstraps;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.kyori.adventure.key.Key;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@Immutable
public final class MetaData
implements MetaContainer<MetaData> {
    private final Map<Key, Object> meta;

    public MetaData() {
        this(Collections.emptyMap());
    }

    private MetaData(Map<Key, Object> meta) {
        this.meta = meta;
    }

    @Override
    public <P, C> MetaData withMeta(Key key, MetaDataType<P, C> type, C value) {
        return new MetaData(Stream.concat(this.meta.entrySet().stream(), Stream.of(Map.entry(key, type.toPrimitive(value)))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (oldValue, newValue) -> newValue)));
    }

    @Override
    public MetaData withoutMeta(Key key) {
        return new MetaData(this.meta.entrySet().stream().filter(entry -> !((Key)entry.getKey()).equals((Object)key)).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)));
    }

    @Override
    public MetaData meta() {
        return this;
    }

    @Override
    @Nullable
    public <P, C> C meta(Key key, MetaDataType<P, C> type) {
        Object value = this.meta.get(key);
        if (value == null) {
            return null;
        }
        if (!type.getPrimitiveType().isInstance(value)) {
            throw new IllegalArgumentException("Meta for " + String.valueOf(key) + " is not of type " + type.getPrimitiveType().getSimpleName());
        }
        if (type instanceof ListMetaDataType) {
            ListMetaDataType listType = (ListMetaDataType)type;
            List list = (List)value;
            if (!list.isEmpty() && !listType.getElementDataType().getPrimitiveType().isInstance(list.getFirst())) {
                throw new IllegalArgumentException("Meta for " + String.valueOf(key) + " is not of List with element type " + listType.getElementDataType().getPrimitiveType().getSimpleName());
            }
        }
        return type.toComplex(type.getPrimitiveType().cast(value));
    }

    @Override
    public <P, C> boolean hasMeta(Key key, MetaDataType<P, C> type) {
        Object value = this.meta.get(key);
        if (value == null) {
            return false;
        }
        if (!type.getPrimitiveType().isInstance(value)) {
            return false;
        }
        if (type instanceof ListMetaDataType) {
            ListMetaDataType listType = (ListMetaDataType)type;
            List list = (List)value;
            return list.isEmpty() || listType.getElementDataType().getPrimitiveType().isInstance(list.getFirst());
        }
        return true;
    }

    @Override
    public Set<Key> metaKeys() {
        return this.meta.keySet();
    }

    @ApiStatus.Internal
    public Map<Key, Object> primitiveMap() {
        return this.meta;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object o) {
        if (!(o instanceof MetaData)) return false;
        MetaData metaData = (MetaData)o;
        if (!MetaData.areMapsEqual(this.meta, metaData.meta)) return false;
        return true;
    }

    private static <K, V> boolean areMapsEqual(Map<K, V> map1, Map<K, V> map2) {
        return map1.size() == map2.size() && map1.entrySet().stream().allMatch(entry -> MetaData.areEqual(entry.getValue(), map2.get(entry.getKey())));
    }

    private static boolean areListsEqual(List<?> list1, List<?> list2) {
        if (list1.size() != list2.size()) {
            return false;
        }
        for (int i = 0; i < list1.size(); ++i) {
            if (MetaData.areEqual(list1.get(i), list2.get(i))) continue;
            return false;
        }
        return true;
    }

    private static boolean areEqual(Object obj1, Object obj2) {
        Object[] arr1;
        if (obj1 instanceof byte[]) {
            arr1 = (byte[])obj1;
            if (obj2 instanceof byte[]) {
                byte[] arr2 = (byte[])obj2;
                return Arrays.equals(arr1, arr2);
            }
        }
        if (obj1 instanceof int[]) {
            arr1 = (int[])obj1;
            if (obj2 instanceof int[]) {
                int[] arr2 = (int[])obj2;
                return Arrays.equals((int[])arr1, arr2);
            }
        }
        if (obj1 instanceof long[]) {
            arr1 = (long[])obj1;
            if (obj2 instanceof long[]) {
                long[] arr2 = (long[])obj2;
                return Arrays.equals((long[])arr1, arr2);
            }
        }
        if (obj1 instanceof List) {
            List list1 = (List)obj1;
            if (obj2 instanceof List) {
                List list2 = (List)obj2;
                return MetaData.areListsEqual(list1, list2);
            }
        }
        return obj1.equals(obj2);
    }

    public String toString() {
        return this.meta.entrySet().stream().map(entry -> String.valueOf(entry.getKey()) + "=" + this.asString(entry.getValue())).collect(Collectors.joining(", ", "MetaData{", "}"));
    }

    private String asString(Object value) {
        Object object = value;
        Objects.requireNonNull(object);
        Object object2 = object;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{byte[].class, int[].class, long[].class, List.class}, (Object)object2, n)) {
            case 0 -> {
                byte[] arr = (byte[])object2;
                yield Arrays.toString(arr);
            }
            case 1 -> {
                int[] arr = (int[])object2;
                yield Arrays.toString(arr);
            }
            case 2 -> {
                long[] arr = (long[])object2;
                yield Arrays.toString(arr);
            }
            case 3 -> {
                List list = (List)object2;
                yield list.stream().map(this::asString).collect(Collectors.joining(", "));
            }
            default -> value.toString();
        };
    }
}

