/*
 * Decompiled with CFR 0.152.
 */
package dev.jsinco.brewery.api.ingredient;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import dev.jsinco.brewery.api.ingredient.Ingredient;
import dev.jsinco.brewery.api.ingredient.IngredientMeta;
import dev.jsinco.brewery.api.ingredient.IngredientWithMeta;
import dev.jsinco.brewery.api.util.BreweryKey;
import dev.jsinco.brewery.api.util.BreweryRegistry;
import dev.jsinco.brewery.api.util.Pair;
import dev.jsinco.brewery.api.util.StringUtil;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public interface IngredientManager<I> {
    public static final Pattern INGREDIENT_META_DATA_RE = Pattern.compile("\\{(.*)\\}");
    public static final Pattern INGREDIENT_META_DATA_KEY_RE = Pattern.compile("[^,{}]+");

    public Ingredient getIngredient(@NotNull I var1);

    public CompletableFuture<Optional<Ingredient>> getIngredient(@NotNull String var1);

    default public CompletableFuture<Optional<Ingredient>> deserializeIngredient(@NotNull String serializedIngredient) throws IllegalArgumentException {
        Matcher matcher = INGREDIENT_META_DATA_RE.matcher(serializedIngredient);
        if (!matcher.find()) {
            return this.getIngredient(serializedIngredient);
        }
        String meta = matcher.group(1);
        String id = matcher.replaceAll("");
        if (meta.isBlank()) {
            return this.getIngredient(id);
        }
        ImmutableMap.Builder metaBuilder = new ImmutableMap.Builder();
        StringUtil.complexSplit(meta).forEach(metaElement -> this.addMeta((String)metaElement, (ImmutableMap.Builder<IngredientMeta<?>, Object>)metaBuilder));
        return this.getIngredient(id).thenApply(ingredientOptional -> ingredientOptional.map(ingredient -> new IngredientWithMeta((Ingredient)ingredient, (Map<IngredientMeta<?>, Object>)metaBuilder.build())));
    }

    private void addMeta(String metaElement, ImmutableMap.Builder<IngredientMeta<?>, Object> metaBuilder) {
        String[] split = metaElement.split("=", 2);
        Preconditions.checkArgument((split.length == 2 ? 1 : 0) != 0, (Object)("Invalid ingredient meta pattern, missing '=' sign: " + metaElement));
        String key = split[0].strip();
        Preconditions.checkArgument((boolean)INGREDIENT_META_DATA_KEY_RE.matcher(key).matches(), (Object)("Invalid ingredient meta key pattern, disallowed symbol: " + key));
        String value = split[1].strip();
        IngredientMeta<?> ingredientMeta = BreweryRegistry.INGREDIENT_META.get(BreweryKey.parse(key));
        Preconditions.checkArgument((ingredientMeta != null ? 1 : 0) != 0, (Object)("Invalid ingredient meta, unknown key: " + key));
        Object deserialized = ingredientMeta.serializer().deserialize(value);
        metaBuilder.put(ingredientMeta, deserialized);
    }

    default public String serializeIngredient(Ingredient ingredient) throws IllegalArgumentException {
        if (!(ingredient instanceof IngredientWithMeta)) {
            return ingredient.getKey();
        }
        IngredientWithMeta metaIngredient = (IngredientWithMeta)ingredient;
        Map<IngredientMeta<?>, Object> meta = metaIngredient.meta();
        return String.format("%s{%s}", metaIngredient.getKey(), meta.entrySet().stream().map(entry -> ((IngredientMeta)entry.getKey()).key().minimalized() + "=" + ((IngredientMeta)entry.getKey()).serializer().serialize(entry.getValue())).collect(Collectors.joining(",")));
    }

    public CompletableFuture<Pair<Ingredient, Integer>> getIngredientWithAmount(String var1) throws IllegalArgumentException;

    public CompletableFuture<Pair<Ingredient, Integer>> getIngredientWithAmount(String var1, boolean var2) throws IllegalArgumentException;

    public CompletableFuture<Map<Ingredient, Integer>> getIngredientsWithAmount(List<String> var1) throws IllegalArgumentException;

    public static void merge(Map<Ingredient, Integer> mutableIngredientsMap, Map<Ingredient, Integer> ingredients) {
        for (Map.Entry<Ingredient, Integer> ingredient : ingredients.entrySet()) {
            IngredientManager.insertIngredientIntoMap(mutableIngredientsMap, new Pair<Ingredient, Integer>(ingredient.getKey(), ingredient.getValue()));
        }
    }

    public static void insertIngredientIntoMap(Map<Ingredient, Integer> mutableIngredientsMap, Pair<Ingredient, Integer> ingredient) {
        int amount = mutableIngredientsMap.computeIfAbsent(ingredient.first(), ignored -> 0);
        mutableIngredientsMap.put(ingredient.first(), amount + ingredient.second());
    }

    public CompletableFuture<Map<Ingredient, Integer>> getIngredientsWithAmount(List<String> var1, boolean var2) throws IllegalArgumentException;
}

