/*
 * Decompiled with CFR 0.152.
 */
package dev.jsinco.brewery.util;

import dev.jsinco.brewery.api.brew.Brew;
import dev.jsinco.brewery.api.brew.BrewQuality;
import dev.jsinco.brewery.api.brew.BrewScore;
import dev.jsinco.brewery.api.brew.BrewingStep;
import dev.jsinco.brewery.api.brew.PartialBrewScore;
import dev.jsinco.brewery.api.brew.ScoreType;
import dev.jsinco.brewery.api.effect.modifier.DrunkenModifier;
import dev.jsinco.brewery.api.ingredient.Ingredient;
import dev.jsinco.brewery.api.recipe.RecipeRegistry;
import dev.jsinco.brewery.configuration.Config;
import dev.jsinco.brewery.configuration.DrunkenModifierSection;
import dev.jsinco.brewery.format.TimeFormat;
import dev.jsinco.brewery.format.TimeFormatter;
import dev.jsinco.brewery.format.TimeModifier;
import dev.jsinco.brewery.recipes.BrewScoreImpl;
import dev.jsinco.brewery.util.NumberFormatting;
import java.lang.runtime.SwitchBootstraps;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.TranslatableComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.StyleBuilderApplicable;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.kyori.adventure.text.minimessage.tag.resolver.Formatter;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import net.kyori.adventure.text.minimessage.translation.Argument;
import net.kyori.adventure.translation.GlobalTranslator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MessageUtil {
    private static final char SKULL = '\u2620';
    private static final char FULL_STAR = '\u2605';
    private static final char HALF_STAR = '\u2bea';
    private static final char EMPTY_STAR = '\u2606';

    public static Component miniMessage(String miniMessage, TagResolver ... resolvers) {
        return MiniMessage.miniMessage().deserialize(miniMessage, resolvers);
    }

    public static void message(Audience audience, String translationKey, TagResolver ... resolvers) {
        audience.sendMessage((Component)Component.translatable((String)translationKey, (ComponentLike[])new ComponentLike[]{Argument.tagResolver((TagResolver[])resolvers)}));
    }

    public static Component translated(String translationKey, TagResolver ... resolvers) {
        return GlobalTranslator.render((Component)Component.translatable((String)translationKey, (ComponentLike[])new ComponentLike[]{Argument.tagResolver((TagResolver[])resolvers)}), (Locale)Config.config().language());
    }

    public static TagResolver getScoreTagResolver(@NotNull BrewScore score) {
        BrewQuality quality = score.brewQuality();
        return TagResolver.resolver((TagResolver[])new TagResolver[]{Placeholder.component((String)"quality", (ComponentLike)score.displayName()), Placeholder.styling((String)"quality_color", (StyleBuilderApplicable[])MessageUtil.resolveQualityColor(quality))});
    }

    @NotNull
    public static TagResolver getBrewStepTagResolver(BrewingStep brewingStep, Map<ScoreType, PartialBrewScore> scores, double difficulty) {
        BrewingStep brewingStep2 = brewingStep;
        Objects.requireNonNull(brewingStep2);
        BrewingStep brewingStep3 = brewingStep2;
        int n = 0;
        TagResolver resolver = switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{BrewingStep.Age.class, BrewingStep.Cook.class, BrewingStep.Distill.class, BrewingStep.Mix.class}, (Object)brewingStep3, n)) {
            case 0 -> {
                BrewingStep.Age age = (BrewingStep.Age)brewingStep3;
                yield TagResolver.resolver((TagResolver[])new TagResolver[]{Placeholder.component((String)"barrel_type", (ComponentLike)GlobalTranslator.render((Component)Component.translatable((String)("tbp.barrel.type." + age.barrelType().name().toLowerCase(Locale.ROOT))), (Locale)Config.config().language())), Placeholder.parsed((String)"aging_years", (String)TimeFormatter.format(age.time().moment(), TimeFormat.AGING_YEARS, TimeModifier.AGING))});
            }
            case 1 -> {
                BrewingStep.Cook cook = (BrewingStep.Cook)brewingStep3;
                yield TagResolver.resolver((TagResolver[])new TagResolver[]{Placeholder.parsed((String)"cooking_time", (String)TimeFormatter.format(cook.time().moment(), TimeFormat.COOKING_TIME, TimeModifier.COOKING)), Placeholder.component((String)"ingredients", (ComponentLike)((ComponentLike)cook.ingredients().entrySet().stream().map(entry -> ((Ingredient)entry.getKey()).displayName().append((Component)Component.text((String)("/" + String.valueOf(entry.getValue()))))).collect(Component.toComponent((Component)Component.text((String)", "))))), Placeholder.component((String)"cauldron_type", (ComponentLike)Component.translatable((String)("tbp.cauldron.type." + cook.cauldronType().name().toLowerCase(Locale.ROOT))))});
            }
            case 2 -> {
                BrewingStep.Distill distill = (BrewingStep.Distill)brewingStep3;
                yield TagResolver.resolver((TagResolver[])new TagResolver[]{Formatter.number((String)"distill_runs", (Number)distill.runs()), Placeholder.unparsed((String)"distill_runs_numerals", (String)NumberFormatting.toRoman(distill.runs()))});
            }
            case 3 -> {
                BrewingStep.Mix mix = (BrewingStep.Mix)brewingStep3;
                yield TagResolver.resolver((TagResolver[])new TagResolver[]{Placeholder.parsed((String)"mixing_time", (String)TimeFormatter.format(mix.time().moment(), TimeFormat.MIXING_TIME, TimeModifier.COOKING)), Placeholder.component((String)"ingredients", (ComponentLike)((ComponentLike)mix.ingredients().entrySet().stream().map(entry -> ((Ingredient)entry.getKey()).displayName().append((Component)Component.text((String)("/" + String.valueOf(entry.getValue()))))).collect(Component.toComponent((Component)Component.text((String)", ")))))});
            }
            default -> throw new IllegalStateException("Unexpected value: " + String.valueOf(brewingStep));
        };
        return TagResolver.resolver((TagResolver[])new TagResolver[]{resolver, TagResolver.resolver((TagResolver[])((TagResolver[])scores.values().stream().map(partialBrewScore -> Placeholder.styling((String)partialBrewScore.type().colorKey(), (StyleBuilderApplicable[])MessageUtil.resolveQualityColor(BrewScoreImpl.quality(BrewScoreImpl.applyDifficulty(partialBrewScore.score(), difficulty))))).toArray(TagResolver[]::new)))});
    }

    @NotNull
    public static StyleBuilderApplicable[] resolveQualityColor(@Nullable BrewQuality quality) {
        StyleBuilderApplicable[] styleBuilderApplicableArray;
        if (quality != null) {
            StyleBuilderApplicable[] styleBuilderApplicableArray2 = new StyleBuilderApplicable[1];
            styleBuilderApplicableArray = styleBuilderApplicableArray2;
            styleBuilderApplicableArray2[0] = TextColor.color((int)quality.getColor());
        } else {
            StyleBuilderApplicable[] styleBuilderApplicableArray3 = new StyleBuilderApplicable[2];
            styleBuilderApplicableArray3[0] = NamedTextColor.GRAY;
            styleBuilderApplicableArray = styleBuilderApplicableArray3;
            styleBuilderApplicableArray3[1] = TextDecoration.STRIKETHROUGH;
        }
        return styleBuilderApplicableArray;
    }

    @NotNull
    public static Stream<Component> compileBrewInfo(Brew brew, BrewScore score, boolean detailed) {
        List<BrewingStep> brewingSteps = brew.getCompletedSteps();
        Stream.Builder<TranslatableComponent> streamBuilder = Stream.builder();
        for (int i = 0; i < brewingSteps.size(); ++i) {
            BrewingStep brewingStep = brewingSteps.get(i);
            String translationKey = (detailed ? "tbp.brew.detailed-tooltip." : "tbp.brew.tooltip-brewing.") + brewingStep.stepType().name().toLowerCase(Locale.ROOT);
            streamBuilder.add(Component.translatable((String)translationKey, (ComponentLike[])new ComponentLike[]{Argument.tagResolver((TagResolver)MessageUtil.getBrewStepTagResolver(brewingStep, score.getPartialScores(i), score.brewDifficulty()))}));
        }
        return streamBuilder.build();
    }

    @NotNull
    public static Stream<Component> compileBrewInfo(Brew brew, boolean detailed, RecipeRegistry<?> registry) {
        BrewScore score = brew.closestRecipe(registry).map(brew::score).orElse(BrewScoreImpl.failed(brew));
        return MessageUtil.compileBrewInfo(brew, score, detailed);
    }

    @NotNull
    public static TagResolver getValueDisplayTagResolver(double displayValue) {
        return TagResolver.resolver((TagResolver[])new TagResolver[]{Placeholder.component((String)"bars", (ComponentLike)MessageUtil.compileBars(displayValue)), Placeholder.component((String)"skulls", (ComponentLike)MessageUtil.compileSkulls(displayValue)), Placeholder.component((String)"stars", (ComponentLike)MessageUtil.compileStars(displayValue))});
    }

    @NotNull
    private static ComponentLike compileSkulls(double level) {
        int partition = (int)level / 20;
        StringBuilder skulls = new StringBuilder();
        skulls.repeat(9760, partition);
        skulls.repeat("  ", 5 - partition);
        return Component.text((String)skulls.toString()).color((TextColor)NamedTextColor.GREEN);
    }

    @NotNull
    private static ComponentLike compileBars(double level) {
        int partitionedLevel = (int)level / 5;
        StringBuilder okLevel = new StringBuilder();
        okLevel.repeat("|", Math.min(partitionedLevel, 4));
        StringBuilder warningLevel = new StringBuilder();
        warningLevel.repeat("|", Math.max(Math.min(partitionedLevel, 16) - 4, 0));
        StringBuilder severeLevel = new StringBuilder();
        severeLevel.repeat("|", Math.max(partitionedLevel - 16, 0));
        StringBuilder remainder = new StringBuilder();
        remainder.repeat("|", 20 - partitionedLevel);
        return ((TextComponent)((TextComponent)((TextComponent)Component.text((String)okLevel.toString()).color((TextColor)NamedTextColor.GREEN)).append(Component.text((String)warningLevel.toString()).color((TextColor)NamedTextColor.YELLOW))).append(Component.text((String)severeLevel.toString()).color((TextColor)NamedTextColor.GOLD))).append(Component.text((String)remainder.toString()).color((TextColor)NamedTextColor.BLACK));
    }

    @NotNull
    private static Component compileStars(double level) {
        StringBuilder builder = new StringBuilder();
        int score = (int)(level / 10.0);
        int fullStars = score / 2;
        int remainder = score % 2;
        builder.repeat(9733, fullStars);
        if (remainder == 1) {
            builder.append('\u2bea');
            builder.repeat(9734, 4 - fullStars);
        } else {
            builder.repeat(9734, 5 - fullStars);
        }
        return Component.text((String)builder.toString());
    }

    @NotNull
    public static TagResolver getTimeTagResolver(long timeTicks) {
        long cookingMinuteTicks = Config.config().cauldrons().cookingMinuteTicks();
        long seconds = timeTicks % cookingMinuteTicks * 60L / cookingMinuteTicks;
        long minutes = timeTicks / cookingMinuteTicks;
        return Placeholder.parsed((String)"time", (String)String.format("%d:%02d", minutes, seconds));
    }

    public static TagResolver numberedModifierTagResolver(@NotNull Map<DrunkenModifier, Double> modifiers, @Nullable String prefix) {
        TagResolver.Builder builder = TagResolver.builder();
        for (DrunkenModifier modifier : DrunkenModifierSection.modifiers().drunkenModifiers()) {
            double value = modifiers.getOrDefault(modifier, modifier.minValue());
            builder.resolver(Formatter.number((String)((String)(prefix == null ? "" : prefix + "_") + modifier.name()), (Number)value));
        }
        return builder.build();
    }
}

