/*
 * Decompiled with CFR 0.152.
 */
package dev.jsinco.brewery.util;

import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import dev.jsinco.brewery.util.FileUtil;
import java.awt.Color;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

public class ItemColorUtil {
    private static final Map<String, Color> ITEM_COLORS = ItemColorUtil.compileItemColors();

    private ItemColorUtil() {
        throw new IllegalStateException("Utility class");
    }

    private static Map<String, Color> compileItemColors() {
        JsonObject jsonObject = FileUtil.readJsonResource("/colors.json").getAsJsonObject();
        ImmutableMap.Builder immutableMapBuilder = ImmutableMap.builder();
        for (Map.Entry<String, JsonElement> entry : jsonObject.entrySet()) {
            immutableMapBuilder.put((Object)("minecraft:" + entry.getKey()), (Object)new Color(Integer.parseInt(entry.getValue().getAsString(), 16)));
        }
        return immutableMapBuilder.build();
    }

    @Nullable
    public static Color getItemColor(String itemId) {
        return ITEM_COLORS.get(itemId);
    }
}

