/*
 * Decompiled with CFR 0.152.
 */
package dev.jsinco.brewery.meta;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import dev.jsinco.brewery.api.meta.ListMetaDataType;
import dev.jsinco.brewery.api.meta.MetaData;
import dev.jsinco.brewery.api.meta.MetaDataType;
import java.lang.runtime.SwitchBootstraps;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import net.kyori.adventure.key.Key;

public class MetaSerializer {
    public static final MetaSerializer INSTANCE = new MetaSerializer();
    private static final Gson GSON = new Gson();
    private static final char LIST_TYPE_CHARACTER = '[';
    private static final char META_TYPE_CHARACTER = '{';
    private static final List<Primitive<?>> PRIMITIVES = List.of(new Primitive<Byte>('b', MetaDataType.BYTE, MetaDataType.BYTE_LIST, JsonElement::getAsByte), new Primitive<Short>('s', MetaDataType.SHORT, MetaDataType.SHORT_LIST, JsonElement::getAsShort), new Primitive<Integer>('i', MetaDataType.INTEGER, MetaDataType.INTEGER_LIST, JsonElement::getAsInt), new Primitive<Long>('l', MetaDataType.LONG, MetaDataType.LONG_LIST, JsonElement::getAsLong), new Primitive<Float>('f', MetaDataType.FLOAT, MetaDataType.FLOAT_LIST, JsonElement::getAsFloat), new Primitive<Double>('d', MetaDataType.DOUBLE, MetaDataType.DOUBLE_LIST, JsonElement::getAsDouble), new Primitive<String>('S', MetaDataType.STRING, MetaDataType.STRING_LIST, JsonElement::getAsString), new Primitive<byte[]>('B', MetaDataType.BYTE_ARRAY, MetaDataType.BYTE_ARRAY_LIST, e -> GSON.fromJson((JsonElement)e, byte[].class)), new Primitive<int[]>('I', MetaDataType.INTEGER_ARRAY, MetaDataType.INTEGER_ARRAY_LIST, e -> GSON.fromJson((JsonElement)e, int[].class)), new Primitive<long[]>('L', MetaDataType.LONG_ARRAY, MetaDataType.LONG_ARRAY_LIST, e -> GSON.fromJson((JsonElement)e, long[].class)));

    public JsonObject serialize(MetaData meta) {
        JsonObject json = new JsonObject();
        block4: for (Map.Entry<Key, Object> entry : meta.primitiveMap().entrySet()) {
            Object object;
            Key metaKey = entry.getKey();
            Object value = entry.getValue();
            Objects.requireNonNull(value);
            int n = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{List.class, MetaData.class}, (Object)object, n)) {
                case 0: {
                    List list = (List)object;
                    json.add("[" + metaKey.toString(), this.serializedList(list));
                    continue block4;
                }
                case 1: {
                    MetaData nestedMeta = (MetaData)object;
                    json.add("{" + metaKey.toString(), this.serialize(nestedMeta));
                    continue block4;
                }
            }
            json.add(MetaSerializer.typeof((Object)value).typeCharacter + metaKey.toString(), GSON.toJsonTree(value));
        }
        return json;
    }

    private JsonArray serializedList(List<?> list) {
        Object first;
        if (list.isEmpty()) {
            return new JsonArray();
        }
        Object obj = first = list.getFirst();
        Objects.requireNonNull(obj);
        Object obj2 = obj;
        int n = 0;
        char typeCharacter = switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{List.class, MetaData.class}, obj2, n)) {
            case 0 -> {
                List ignored = (List)obj2;
                yield '[';
            }
            case 1 -> {
                MetaData ignored = (MetaData)obj2;
                yield '{';
            }
            default -> MetaSerializer.typeof(first).typeCharacter;
        };
        JsonArray arr = new JsonArray();
        arr.add(Character.valueOf(typeCharacter));
        list.stream().map(value -> {
            Object object = value;
            Objects.requireNonNull(object);
            Object selector0$temp = object;
            int index$1 = 0;
            return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{List.class, MetaData.class}, (Object)selector0$temp, index$1)) {
                case 0 -> {
                    List nestedList = (List)selector0$temp;
                    yield this.serializedList(nestedList);
                }
                case 1 -> {
                    MetaData meta = (MetaData)selector0$temp;
                    yield this.serialize(meta);
                }
                default -> GSON.toJsonTree(value);
            };
        }).forEach(arr::add);
        return arr;
    }

    public MetaData deserialize(JsonObject json) {
        MetaData meta = new MetaData();
        for (Map.Entry<String, JsonElement> entry : json.entrySet()) {
            String jsonKey = entry.getKey();
            JsonElement jsonValue = entry.getValue();
            char typeCharacter = jsonKey.charAt(0);
            Key metaKey = Key.key((String)jsonKey.substring(1));
            meta = switch (typeCharacter) {
                case '[' -> this.withList(meta, metaKey, jsonValue.getAsJsonArray());
                case '{' -> meta.withMeta(metaKey, (MetaDataType)MetaDataType.CONTAINER, this.deserialize(jsonValue.getAsJsonObject()));
                default -> MetaSerializer.primitiveFromChar(typeCharacter).metaWithValue(meta, metaKey, jsonValue);
            };
        }
        return meta;
    }

    private MetaData withList(MetaData meta, Key metaKey, JsonArray arr) {
        if (arr.isEmpty()) {
            return meta.withMeta(metaKey, MetaDataType.STRING_LIST, List.of());
        }
        char typeCharacter = arr.get(0).getAsString().charAt(0);
        arr.remove(0);
        return switch (typeCharacter) {
            case '[' -> {
                List<List> list = arr.asList().stream().map(JsonElement::getAsJsonArray).map(this::convertTypedArray).toList();
                yield meta.withMeta(metaKey, (MetaDataType)UntypedListDataType.INSTANCE, list);
            }
            case '{' -> {
                List<MetaData> list = arr.asList().stream().map(JsonElement::getAsJsonObject).map(this::deserialize).toList();
                yield meta.withMeta(metaKey, MetaDataType.CONTAINER_LIST, list);
            }
            default -> MetaSerializer.primitiveFromChar(typeCharacter).metaWithListOfValues(meta, metaKey, arr);
        };
    }

    private List<?> convertTypedArray(JsonArray arr) {
        if (arr.isEmpty()) {
            return List.of();
        }
        char typeCharacter = arr.get(0).getAsString().charAt(0);
        arr.remove(0);
        return switch (typeCharacter) {
            case '[' -> arr.asList().stream().map(JsonElement::getAsJsonArray).map(this::convertTypedArray).toList();
            case '{' -> arr.asList().stream().map(JsonElement::getAsJsonObject).map(this::deserialize).toList();
            default -> MetaSerializer.primitiveFromChar(typeCharacter).asList(arr);
        };
    }

    private static Primitive<?> primitiveFromChar(char typeCharacter) {
        return PRIMITIVES.stream().filter(p -> p.typeCharacter == typeCharacter).findFirst().orElseThrow();
    }

    private static Primitive<?> typeof(Object value) {
        Object object = value;
        Objects.requireNonNull(object);
        Object object2 = object;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Byte.class, Short.class, Integer.class, Long.class, Float.class, Double.class, String.class, byte[].class, int[].class, long[].class}, (Object)object2, n)) {
            case 0 -> {
                Byte ignored = (Byte)object2;
                yield PRIMITIVES.get(0);
            }
            case 1 -> {
                Short ignored = (Short)object2;
                yield PRIMITIVES.get(1);
            }
            case 2 -> {
                Integer ignored = (Integer)object2;
                yield PRIMITIVES.get(2);
            }
            case 3 -> {
                Long ignored = (Long)object2;
                yield PRIMITIVES.get(3);
            }
            case 4 -> {
                Float ignored = (Float)object2;
                yield PRIMITIVES.get(4);
            }
            case 5 -> {
                Double ignored = (Double)object2;
                yield PRIMITIVES.get(5);
            }
            case 6 -> {
                String ignored = (String)object2;
                yield PRIMITIVES.get(6);
            }
            case 7 -> {
                byte[] ignored = (byte[])object2;
                yield PRIMITIVES.get(7);
            }
            case 8 -> {
                int[] ignored = (int[])object2;
                yield PRIMITIVES.get(8);
            }
            case 9 -> {
                long[] ignored = (long[])object2;
                yield PRIMITIVES.get(9);
            }
            default -> throw new IllegalArgumentException("No type found for " + value.getClass().getSimpleName());
        };
    }

    private record Primitive<P>(char typeCharacter, MetaDataType<P, P> type, ListMetaDataType<P, P> listType, Function<JsonElement, P> jsonToPrimitive) {
        public MetaData metaWithValue(MetaData meta, Key metaKey, JsonElement value) {
            return meta.withMeta(metaKey, (MetaDataType)this.type, this.jsonToPrimitive.apply(value));
        }

        public MetaData metaWithListOfValues(MetaData meta, Key metaKey, JsonArray arr) {
            return meta.withMeta(metaKey, this.listType, this.asList(arr));
        }

        public List<P> asList(JsonArray arr) {
            return arr.asList().stream().map(this.jsonToPrimitive).toList();
        }
    }

    private static class UntypedListDataType
    implements MetaDataType<List<?>, List<?>> {
        public static final UntypedListDataType INSTANCE = new UntypedListDataType();

        private UntypedListDataType() {
        }

        @Override
        public Class<List<?>> getPrimitiveType() {
            return List.class;
        }

        @Override
        public Class<List<?>> getComplexType() {
            return List.class;
        }

        @Override
        public List<?> toPrimitive(List<?> complex) {
            return complex;
        }

        @Override
        public List<?> toComplex(List<?> primitive) {
            return primitive;
        }
    }
}

