/*
 * Decompiled with CFR 0.152.
 */
package dev.jsinco.brewery.bukkit.util;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Streams;
import dev.jsinco.brewery.api.effect.modifier.ModifierExpression;
import dev.jsinco.brewery.api.event.CustomEvent;
import dev.jsinco.brewery.api.event.DrunkEvent;
import dev.jsinco.brewery.api.event.EventData;
import dev.jsinco.brewery.api.event.EventProbability;
import dev.jsinco.brewery.api.event.EventStep;
import dev.jsinco.brewery.api.event.EventStepProperty;
import dev.jsinco.brewery.api.meta.MetaDataType;
import dev.jsinco.brewery.api.util.BreweryKey;
import dev.jsinco.brewery.api.util.BreweryRegistry;
import dev.jsinco.brewery.bukkit.TheBrewingProject;
import dev.jsinco.brewery.bukkit.api.integration.EventIntegration;
import dev.jsinco.brewery.bukkit.api.integration.IntegrationTypes;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import javax.annotation.Nullable;

public class EventUtil {
    public static Optional<DrunkEvent> fromData(EventData data) {
        TheBrewingProject theBrewingProject = TheBrewingProject.getInstance();
        BreweryKey key = data.key();
        ModifierExpression modifierExpressionOverride = null;
        try {
            String temp = data.data(EventData.PROBABILITY_KEY, MetaDataType.STRING);
            if (temp != null) {
                modifierExpressionOverride = new ModifierExpression(temp);
            }
        }
        catch (Exception temp) {
            // empty catch block
        }
        ModifierExpression finalProbabilityWeight = modifierExpressionOverride;
        return Optional.ofNullable((DrunkEvent)BreweryRegistry.DRUNK_EVENT.get(key)).or(() -> Optional.ofNullable(theBrewingProject.getCustomDrunkEventRegistry().getCustomEvent(key))).or(() -> theBrewingProject.getIntegrationManager().getIntegrationRegistry().getIntegrations(IntegrationTypes.EVENT).stream().map(eventIntegration -> eventIntegration.convertToEvent(data)).flatMap(Optional::stream).findFirst()).map(drunkEvent -> EventUtil.applyProbability(drunkEvent, finalProbabilityWeight));
    }

    private static DrunkEvent applyProbability(DrunkEvent drunkEvent, @Nullable ModifierExpression probability) {
        DrunkEvent drunkEvent2;
        if (probability == null || !(drunkEvent instanceof EventStepProperty)) {
            drunkEvent2 = drunkEvent;
        } else {
            EventStepProperty property = (EventStepProperty)((Object)drunkEvent);
            drunkEvent2 = new CustomEvent.Builder().probability(new EventProbability(probability, Map.of())).addStep(new EventStep.Builder().addProperty(property).build()).build(drunkEvent.key());
        }
        return drunkEvent2;
    }

    public static List<BreweryKey> listAll() {
        ImmutableList.Builder keyBuilder = ImmutableList.builder();
        Streams.concat((Stream[])new Stream[]{TheBrewingProject.getInstance().getCustomDrunkEventRegistry().events().stream(), BreweryRegistry.DRUNK_EVENT.values().stream()}).filter(Objects::nonNull).map(DrunkEvent::key).forEach(arg_0 -> ((ImmutableList.Builder)keyBuilder).add(arg_0));
        TheBrewingProject.getInstance().getIntegrationManager().getIntegrationRegistry().getIntegrations(IntegrationTypes.EVENT).stream().map(EventIntegration::listEventKeys).flatMap(Collection::stream).forEach(arg_0 -> ((ImmutableList.Builder)keyBuilder).add(arg_0));
        return keyBuilder.build();
    }
}

