/*
 * Decompiled with CFR 0.152.
 */
package dev.jsinco.brewery.bukkit.util;

import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.ProtocolLibrary;
import com.comphenix.protocol.events.PacketContainer;
import com.comphenix.protocol.wrappers.BlockPosition;
import dev.jsinco.brewery.api.vector.BreweryLocation;
import dev.jsinco.brewery.bukkit.api.BukkitAdapter;
import dev.jsinco.brewery.util.ClassUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockType;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Levelled;
import org.bukkit.block.data.Lightable;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.util.BoundingBox;
import org.bukkit.util.Vector;
import org.bukkit.util.VoxelShape;

public class BlockUtil {
    private static final boolean PROTOCOL_LIB_ENABLED = ClassUtil.exists("com.comphenix.protocol.events.PacketContainer");
    private static final BoundingBox FULL_BLOCK = BoundingBox.of((Vector)new Vector(0, 0, 0), (Vector)new Vector(1, 1, 1));
    private static final ItemStack NO_TOOL = ItemStack.of((Material)Material.AIR);

    public static boolean isChunkLoaded(BreweryLocation block) {
        return BukkitAdapter.toLocation(block).map(Location::isChunkLoaded).orElse(false);
    }

    public static boolean isLitCampfire(Block block) {
        if (block.getType() == Material.CAMPFIRE || block.getType() == Material.SOUL_CAMPFIRE) {
            return ((Lightable)block.getBlockData()).isLit();
        }
        return false;
    }

    public static boolean isSource(Block block) {
        if (block.getType() == Material.LAVA || block.getType() == Material.WATER) {
            return ((Levelled)block.getBlockData()).getLevel() == 0;
        }
        return false;
    }

    public static void playWobbleEffect(BreweryLocation location, Player player) {
        if (!PROTOCOL_LIB_ENABLED) {
            return;
        }
        PacketContainer packet = new PacketContainer(PacketType.Play.Server.BLOCK_ACTION);
        packet.getBlockPositionModifier().writeSafely(0, (Object)new BlockPosition(location.x(), location.y(), location.z()));
        packet.getBytes().writeSafely(0, (Object)1).writeSafely(1, (Object)1);
        packet.getIntegers().writeSafely(0, (Object)1);
        ProtocolLibrary.getProtocolManager().sendServerPacket(player, packet);
    }

    public static boolean isFullBlock(Block block) {
        return BlockUtil.isFullBlock(block.getCollisionShape());
    }

    public static boolean isFullBlock(VoxelShape collisionShape) {
        Collection boxes = collisionShape.getBoundingBoxes();
        if (boxes.size() != 1) {
            return false;
        }
        BoundingBox hitbox = (BoundingBox)boxes.iterator().next();
        return hitbox.contains(FULL_BLOCK);
    }

    public static Set<ToolType> getFasterTools(BlockType blockType) {
        BlockData blockData = blockType.createBlockData();
        return Arrays.stream(ToolType.values()).filter(toolType -> BlockUtil.toolMinesFaster(blockData, toolType)).collect(Collectors.toCollection(() -> EnumSet.noneOf(ToolType.class)));
    }

    private static boolean toolMinesFaster(BlockData blockData, ToolType toolType) {
        return blockData.getDestroySpeed(toolType.sampleToolItem) > blockData.getDestroySpeed(NO_TOOL);
    }

    public static enum ToolType {
        SWORD(Material.NETHERITE_SWORD),
        PICKAXE(Material.NETHERITE_PICKAXE),
        AXE(Material.NETHERITE_AXE),
        SHOVEL(Material.NETHERITE_SHOVEL),
        HOE(Material.NETHERITE_HOE),
        SHEARS(Material.SHEARS);

        private final ItemStack sampleToolItem;

        private ToolType(Material material) {
            this.sampleToolItem = ItemStack.of((Material)material);
        }
    }
}

