/*
 * Decompiled with CFR 0.152.
 */
package dev.jsinco.brewery.bukkit.structure;

import dev.jsinco.brewery.bukkit.structure.BreweryStructure;
import dev.jsinco.brewery.lib.dev.thorinwasher.schem.Schematic;
import dev.jsinco.brewery.lib.dev.thorinwasher.schem.SchematicReader;
import dev.jsinco.brewery.lib.eu.okaeri.configs.OkaeriConfig;
import dev.jsinco.brewery.lib.eu.okaeri.configs.annotation.CustomKey;
import dev.jsinco.brewery.lib.eu.okaeri.configs.annotation.Exclude;
import java.nio.file.Path;
import java.util.regex.Pattern;

public class BreweryStructureConfig
extends OkaeriConfig {
    @CustomKey(value="schem_file")
    String schemFileName;
    @CustomKey(value="meta")
    BreweryStructure.Meta meta;
    @Exclude
    private static final Pattern SCHEM_PATTERN = Pattern.compile("\\.json", 2);

    public BreweryStructure toStructure(Path configFilePath) {
        Path schemFile = configFilePath.resolveSibling(this.schemFileName);
        String schemName = SCHEM_PATTERN.matcher(configFilePath.getFileName().toString()).replaceAll("");
        Schematic schematic = new SchematicReader().read(schemFile);
        return new BreweryStructure(schematic, schemName, this.meta, schemName);
    }
}

