/*
 * Decompiled with CFR 0.152.
 */
package dev.jsinco.brewery.bukkit.recipe;

import com.google.common.base.Preconditions;
import dev.jsinco.brewery.api.brew.BrewQuality;
import dev.jsinco.brewery.api.effect.modifier.DrunkenModifier;
import dev.jsinco.brewery.api.event.EventData;
import dev.jsinco.brewery.api.moment.Interval;
import dev.jsinco.brewery.api.recipe.QualityData;
import dev.jsinco.brewery.api.recipe.QualityDataBuilder;
import dev.jsinco.brewery.api.recipe.RecipeResult;
import dev.jsinco.brewery.bukkit.recipe.BukkitRecipeResult;
import dev.jsinco.brewery.bukkit.recipe.RecipeEffectImpl;
import dev.jsinco.brewery.bukkit.recipe.RecipeEffectsImpl;
import dev.jsinco.brewery.bukkit.util.ColorUtil;
import dev.jsinco.brewery.configuration.DrunkenModifierSection;
import dev.jsinco.brewery.lib.org.simpleyaml.configuration.ConfigurationSection;
import dev.jsinco.brewery.recipes.RecipeResultReader;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.bukkit.NamespacedKey;
import org.bukkit.Registry;
import org.bukkit.inventory.ItemStack;
import org.bukkit.potion.PotionEffectType;

public class BukkitRecipeResultReader
implements RecipeResultReader<ItemStack> {
    @Override
    public QualityData<RecipeResult<ItemStack>> readRecipeResults(ConfigurationSection configurationSection) {
        QualityDataBuilder qualityDataBuilder = new QualityDataBuilder(BukkitRecipeResult.Builder::new);
        qualityDataBuilder.addOptional(configurationSection.getString("potion-attributes.custom-model-data"), Integer::parseInt, BukkitRecipeResult.Builder::customModelData);
        qualityDataBuilder.addOptionalString(configurationSection.getString("potion-attributes.item-model"), BukkitRecipeResult.Builder::itemModel);
        qualityDataBuilder.addOptionalStringList(configurationSection.getStringList("potion-attributes.lore"), BukkitRecipeResult.Builder::lore);
        qualityDataBuilder.addOptional(configurationSection.getString("potion-attributes.glint"), Boolean::parseBoolean, BukkitRecipeResult.Builder::glint);
        qualityDataBuilder.addString(configurationSection.getString("potion-attributes.name"), "Expected field 'potion-attributes.name'!", BukkitRecipeResult.Builder::name);
        qualityDataBuilder.add(configurationSection.getString("potion-attributes.color"), "Expected field 'potion-attributes.color'!", ColorUtil::parseColorString, BukkitRecipeResult.Builder::color);
        qualityDataBuilder.addOptional(configurationSection.getString("potion-attributes.append-brew-info-lore"), Boolean::parseBoolean, BukkitRecipeResult.Builder::appendBrewInfoLore);
        qualityDataBuilder.addOptionalString(configurationSection.getString("potion-attributes.custom-id"), BukkitRecipeResult.Builder::customId);
        qualityDataBuilder.add(BukkitRecipeResultReader.getRecipeEffects(configurationSection), BukkitRecipeResult.Builder::recipeEffects);
        return qualityDataBuilder.build();
    }

    private static QualityData<RecipeEffectsImpl> getRecipeEffects(ConfigurationSection configurationSection) {
        QualityDataBuilder qualityDataBuilder = new QualityDataBuilder(RecipeEffectsImpl.Builder::new);
        qualityDataBuilder.addOptionalString(configurationSection.getString("messages.action-bar"), RecipeEffectsImpl.Builder::actionBar);
        qualityDataBuilder.addOptionalString(configurationSection.getString("messages.title"), RecipeEffectsImpl.Builder::title);
        qualityDataBuilder.addOptionalString(configurationSection.getString("messages.message"), RecipeEffectsImpl.Builder::message);
        qualityDataBuilder.addOptionalList(configurationSection.getStringList("effects"), BukkitRecipeResultReader::getEffect, RecipeEffectsImpl.Builder::effects);
        qualityDataBuilder.addOptionalList(configurationSection.getStringList("events"), EventData::deserialize, RecipeEffectsImpl.Builder::eventData);
        qualityDataBuilder.add(BukkitRecipeResultReader.parseModifiers(configurationSection), RecipeEffectsImpl.Builder::addModifiers);
        return qualityDataBuilder.build();
    }

    private static QualityData<Map<DrunkenModifier, Double>> parseModifiers(ConfigurationSection configurationSection) {
        HashMap<DrunkenModifier, QualityData> modifierQualityMap = new HashMap<DrunkenModifier, QualityData>();
        if (configurationSection.isConfigurationSection("modifiers")) {
            ConfigurationSection qualityDataSection = configurationSection.getConfigurationSection("modifiers");
            for (String modifier2 : qualityDataSection.getKeys(false)) {
                modifierQualityMap.put(DrunkenModifierSection.modifiers().modifier(modifier2), QualityData.readQualityFactoredString(qualityDataSection.getString(modifier2)).map(Double::parseDouble));
            }
        }
        QualityData<HashMap> output = QualityData.fromValueMapper(ignored -> new HashMap());
        modifierQualityMap.forEach((modifier, qualityData) -> qualityData.forEach((quality, aDouble) -> ((HashMap)output.get((BrewQuality)((Object)((Object)quality)))).put(modifier, aDouble)));
        return output.map(Map::copyOf);
    }

    private static RecipeEffectImpl getEffect(String string) {
        Interval amplifierBounds;
        Interval durationBounds;
        if (!string.contains("/")) {
            PotionEffectType type = (PotionEffectType)Registry.EFFECT.get(NamespacedKey.fromString((String)string.toLowerCase(Locale.ROOT)));
            Preconditions.checkNotNull((Object)type);
            return new RecipeEffectImpl(type, new Interval(1L, 1L), new Interval(1L, 1L));
        }
        String[] parts = string.split("/");
        PotionEffectType type = PotionEffectType.getByName((String)parts[0]);
        Preconditions.checkNotNull((Object)type, (Object)("invalid effect type: " + parts[0]));
        if (parts.length == 3) {
            durationBounds = Interval.parse(parts[2]).multiply(20);
            amplifierBounds = Interval.parse(parts[1]);
        } else if (type.isInstant()) {
            durationBounds = new Interval(1L, 1L);
            amplifierBounds = Interval.parse(parts[1]);
        } else {
            durationBounds = Interval.parse(parts[1]).multiply(20);
            amplifierBounds = new Interval(0L, 0L);
        }
        return new RecipeEffectImpl(type, durationBounds, amplifierBounds);
    }
}

