/*
 * Decompiled with CFR 0.152.
 */
package dev.jsinco.brewery.bukkit.migration.breweryx;

import java.io.InputStream;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;

public class SeedInputStream
extends InputStream {
    private static final long multiplier = 25214903917L;
    private static final long addend = 11L;
    private static final long mask = 0xFFFFFFFFFFFFL;
    private long seed;
    private byte[] buf = new byte[4];
    private byte reader = (byte)4;
    private long markSeed;
    private byte[] markbuf;

    public SeedInputStream(long seed) {
        this.seed = (seed ^ 0x5DEECE66DL) & 0xFFFFFFFFFFFFL;
    }

    private void calcSeed() {
        this.seed = this.seed * 25214903917L + 11L & 0xFFFFFFFFFFFFL;
    }

    private void genNext() {
        this.calcSeed();
        int next = (int)(this.seed >>> 16);
        this.buf[0] = (byte)(next >> 24);
        this.buf[1] = (byte)(next >> 16);
        this.buf[2] = (byte)(next >> 8);
        this.buf[3] = (byte)next;
        this.reader = 0;
    }

    @Override
    public int read(@NotNull byte[] b, int off, int len) {
        for (int i = off; i < len; ++i) {
            if (this.reader >= 4) {
                this.genNext();
            }
            byte by = this.reader;
            this.reader = (byte)(by + 1);
            b[i] = this.buf[by];
        }
        return len;
    }

    @Override
    public int read() {
        if (this.reader == 4) {
            this.genNext();
        }
        byte by = this.reader;
        this.reader = (byte)(by + 1);
        return this.buf[by];
    }

    @Override
    public long skip(long toSkip) {
        long n = toSkip;
        while (n > 0L) {
            if (this.reader < 4) {
                this.reader = (byte)(this.reader + 1);
                --n;
                continue;
            }
            if (n >= 4L) {
                this.calcSeed();
                n -= 4L;
                continue;
            }
            this.genNext();
        }
        return toSkip;
    }

    @Override
    public void close() {
        this.buf = null;
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public synchronized void mark(int readlimit) {
        this.markbuf = new byte[]{this.buf[0], this.buf[1], this.buf[2], this.buf[3], this.reader};
        this.markSeed = this.seed;
    }

    @Override
    public synchronized void reset() {
        this.seed = this.markSeed;
        this.buf = Arrays.copyOfRange(this.markbuf, 0, 4);
        this.reader = this.markbuf[4];
    }
}

