/*
 * Decompiled with CFR 0.152.
 */
package dev.jsinco.brewery.bukkit.meta;

import dev.jsinco.brewery.api.meta.MetaContainer;
import dev.jsinco.brewery.api.meta.MetaData;
import dev.jsinco.brewery.api.meta.MetaDataType;
import dev.jsinco.brewery.bukkit.meta.MetaUtil;
import java.util.Map;
import java.util.Objects;
import net.kyori.adventure.key.Key;
import org.bukkit.NamespacedKey;
import org.bukkit.persistence.ListPersistentDataType;
import org.bukkit.persistence.PersistentDataAdapterContext;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.jetbrains.annotations.NotNull;
import org.jspecify.annotations.NonNull;

public class MetaDataPdcType
implements PersistentDataType<PersistentDataContainer, MetaData> {
    public static final MetaDataPdcType INSTANCE = new MetaDataPdcType();
    public static final ListPersistentDataType<PersistentDataContainer, MetaData> LIST = PersistentDataType.LIST.listTypeFrom((PersistentDataType)INSTANCE);

    @NotNull
    public Class<PersistentDataContainer> getPrimitiveType() {
        return PersistentDataContainer.class;
    }

    @NotNull
    public Class<MetaData> getComplexType() {
        return MetaData.class;
    }

    public @NonNull PersistentDataContainer toPrimitive(@NonNull MetaData complex, @NotNull PersistentDataAdapterContext context) {
        PersistentDataContainer pdc = context.newPersistentDataContainer();
        for (Map.Entry<Key, Object> entry : complex.primitiveMap().entrySet()) {
            NamespacedKey key = new NamespacedKey(entry.getKey().namespace(), entry.getKey().value());
            Object value = entry.getValue();
            pdc.set(key, MetaUtil.pdcTypeOf(value), value);
        }
        return pdc;
    }

    public @NonNull MetaData fromPrimitive(@NonNull PersistentDataContainer primitive, @NotNull PersistentDataAdapterContext context) {
        MetaContainer<MetaData> meta = new MetaData();
        for (NamespacedKey key : primitive.getKeys()) {
            Object value = Objects.requireNonNull(primitive.get(key, MetaUtil.findType(primitive, key)));
            meta = meta.withMeta(Key.key((String)key.namespace(), (String)key.value()), (MetaDataType)MetaUtil.metaDataTypeOf(value), value);
        }
        return meta;
    }
}

