/*
 * Decompiled with CFR 0.152.
 */
package dev.jsinco.brewery.bukkit.listener;

import dev.jsinco.brewery.api.util.Logger;
import dev.jsinco.brewery.bukkit.TheBrewingProject;
import dev.jsinco.brewery.bukkit.breweries.BreweryRegistry;
import dev.jsinco.brewery.bukkit.breweries.BukkitCauldron;
import dev.jsinco.brewery.bukkit.breweries.BukkitCauldronDataType;
import dev.jsinco.brewery.bukkit.breweries.barrel.BukkitBarrel;
import dev.jsinco.brewery.bukkit.breweries.barrel.BukkitBarrelDataType;
import dev.jsinco.brewery.bukkit.breweries.distillery.BukkitDistillery;
import dev.jsinco.brewery.bukkit.breweries.distillery.BukkitDistilleryDataType;
import dev.jsinco.brewery.database.PersistenceException;
import dev.jsinco.brewery.database.sql.Database;
import dev.jsinco.brewery.structure.PlacedStructureRegistryImpl;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.world.WorldLoadEvent;
import org.bukkit.event.world.WorldUnloadEvent;
import org.bukkit.plugin.Plugin;

public class WorldEventListener
implements Listener {
    private final Database database;
    private final PlacedStructureRegistryImpl placedStructureRegistry;
    private final BreweryRegistry registry;
    private final Executor globalThread = runnable -> Bukkit.getGlobalRegionScheduler().run((Plugin)TheBrewingProject.getInstance(), ignored -> runnable.run());

    public WorldEventListener(Database database, PlacedStructureRegistryImpl placedStructureRegistry, BreweryRegistry registry) {
        this.database = database;
        this.placedStructureRegistry = placedStructureRegistry;
        this.registry = registry;
    }

    public void init() {
        Bukkit.getServer().getWorlds().forEach(this::loadWorld);
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onWorldLoad(WorldLoadEvent event) {
        this.loadWorld(event.getWorld());
    }

    public void onWorldUnload(WorldUnloadEvent event) {
        this.placedStructureRegistry.unloadWorld(event.getWorld().getUID());
    }

    private void loadWorld(World world) {
        try {
            CompletableFuture<List<BukkitBarrel>> barrelsFuture = this.database.find(BukkitBarrelDataType.INSTANCE, world.getUID());
            CompletableFuture<List<BukkitCauldron>> cauldronsFuture = this.database.find(BukkitCauldronDataType.INSTANCE, world.getUID());
            CompletableFuture<List<BukkitDistillery>> distilleriesFuture = this.database.find(BukkitDistilleryDataType.INSTANCE, world.getUID());
            CompletableFuture.allOf(barrelsFuture, distilleriesFuture, cauldronsFuture).thenAcceptAsync(ignored -> {
                for (BukkitBarrel barrel : (List)barrelsFuture.join()) {
                    this.placedStructureRegistry.registerStructure(barrel.getStructure());
                    this.registry.registerInventory(barrel);
                }
                ((List)cauldronsFuture.join()).forEach(this.registry::addActiveSinglePositionStructure);
                for (BukkitDistillery distillery : (List)distilleriesFuture.join()) {
                    this.placedStructureRegistry.registerStructure(distillery.getStructure());
                    this.registry.registerInventory(distillery);
                }
            }, this.globalThread);
        }
        catch (PersistenceException e) {
            Logger.logErr(e);
        }
    }
}

