/*
 * Decompiled with CFR 0.152.
 */
package dev.jsinco.brewery.bukkit.listener;

import dev.jsinco.brewery.api.brew.Brew;
import dev.jsinco.brewery.bukkit.brew.BrewAdapter;
import dev.jsinco.brewery.configuration.Config;
import java.util.Optional;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryOpenEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;

public class BrewMigrationListener
implements Listener {
    private ItemStack migrateItemStack(ItemStack item) {
        if (item == null || item.isEmpty()) {
            return item;
        }
        Optional<Brew> brewOptional = BrewAdapter.fromItem(item);
        if (brewOptional.isEmpty()) {
            return item;
        }
        return BrewAdapter.toItem(brewOptional.get(), new Brew.State.Other());
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        if (!Config.config().reencryptItemsInInventories()) {
            return;
        }
        PlayerInventory inventory = event.getPlayer().getInventory();
        for (int slot = 0; slot < inventory.getSize(); ++slot) {
            inventory.setItem(slot, this.migrateItemStack(inventory.getItem(slot)));
        }
    }

    @EventHandler
    public void onPlayerOpenInventory(InventoryOpenEvent event) {
        if (!Config.config().reencryptItemsInInventories()) {
            return;
        }
        Inventory inventory = event.getInventory();
        if (inventory.getType() == InventoryType.PLAYER) {
            return;
        }
        for (int slot = 0; slot < inventory.getSize(); ++slot) {
            inventory.setItem(slot, this.migrateItemStack(inventory.getItem(slot)));
        }
    }
}

