/*
 * Decompiled with CFR 0.152.
 */
package dev.jsinco.brewery.bukkit.integration.placeholder;

import dev.jsinco.brewery.api.effect.DrunkState;
import dev.jsinco.brewery.api.effect.modifier.DrunkenModifier;
import dev.jsinco.brewery.api.event.DrunkEvent;
import dev.jsinco.brewery.api.util.Pair;
import dev.jsinco.brewery.bukkit.TheBrewingProject;
import dev.jsinco.brewery.bukkit.api.integration.PlaceholderIntegration;
import dev.jsinco.brewery.configuration.DrunkenModifierSection;
import dev.jsinco.brewery.effect.DrunksManagerImpl;
import dev.jsinco.brewery.util.ClassUtil;
import io.github.miniplaceholders.api.Expansion;
import io.github.miniplaceholders.api.MiniPlaceholders;
import io.github.miniplaceholders.api.utils.TagsUtils;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TranslatableComponent;
import net.kyori.adventure.text.minimessage.tag.Tag;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;

public class MiniPlaceholdersIntegration
implements PlaceholderIntegration {
    @Override
    public TagResolver resolve(OfflinePlayer player) {
        if (player instanceof Player) {
            Player onlinePlayer = (Player)player;
            return MiniPlaceholders.getAudiencePlaceholders((Audience)onlinePlayer);
        }
        return TagResolver.empty();
    }

    @Override
    public boolean isEnabled() {
        return ClassUtil.exists("io.github.miniplaceholders.api.utils.TagsUtils");
    }

    @Override
    public String getId() {
        return "miniplaceholders";
    }

    @Override
    public void onEnable() {
        Expansion.Builder builder = Expansion.builder((String)"tbp").filter(Player.class).audiencePlaceholder("next_event", (audience, queue, ctx) -> {
            if (!(audience instanceof Player)) {
                return TagsUtils.EMPTY_TAG;
            }
            Player player = (Player)audience;
            Pair<DrunkEvent, Long> event = ((DrunksManagerImpl)TheBrewingProject.getInstance().getDrunksManager()).getPlannedEvent(player.getUniqueId());
            TranslatableComponent eventComponent = event == null ? Component.translatable((String)"tbp.events.nothing-planned") : event.first().displayName();
            return Tag.selfClosingInserting((Component)eventComponent);
        });
        for (DrunkenModifier modifier : DrunkenModifierSection.modifiers().drunkenModifiers()) {
            builder.audiencePlaceholder(modifier.name(), (audience, argumentQueue, context) -> {
                if (!(audience instanceof Player)) {
                    return TagsUtils.EMPTY_TAG;
                }
                Player player = (Player)audience;
                DrunkState drunkState = ((DrunksManagerImpl)TheBrewingProject.getInstance().getDrunksManager()).getDrunkState(player.getUniqueId());
                return Tag.selfClosingInserting((Component)Component.text((double)(drunkState == null ? 0.0 : drunkState.modifierValue(modifier))));
            });
        }
        ((Expansion)builder.build()).register();
    }
}

