/*
 * Decompiled with CFR 0.152.
 */
package dev.jsinco.brewery.bukkit.ingredient;

import com.google.common.collect.ImmutableMap;
import dev.jsinco.brewery.api.brew.BrewQuality;
import dev.jsinco.brewery.api.ingredient.BaseIngredient;
import dev.jsinco.brewery.api.ingredient.Ingredient;
import dev.jsinco.brewery.api.ingredient.IngredientMeta;
import dev.jsinco.brewery.api.ingredient.IngredientWithMeta;
import dev.jsinco.brewery.api.recipe.RecipeResult;
import dev.jsinco.brewery.api.util.BreweryKey;
import dev.jsinco.brewery.bukkit.TheBrewingProject;
import dev.jsinco.brewery.bukkit.brew.BrewAdapter;
import dev.jsinco.brewery.configuration.IngredientsSection;
import dev.jsinco.brewery.recipes.RecipeRegistryImpl;
import io.papermc.paper.persistence.PersistentDataContainerView;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.MiniMessage;
import org.bukkit.inventory.ItemStack;
import org.bukkit.persistence.PersistentDataType;
import org.jetbrains.annotations.NotNull;

public class BreweryIngredient
implements BaseIngredient {
    protected final BreweryKey ingredientKey;

    public BreweryIngredient(BreweryKey ingredientKey) {
        this.ingredientKey = ingredientKey;
    }

    @Override
    @NotNull
    public String getKey() {
        return this.ingredientKey.toString();
    }

    @Override
    @NotNull
    public Component displayName() {
        return ((RecipeRegistryImpl)TheBrewingProject.getInstance().getRecipeRegistry()).getRecipe(this.ingredientKey.minimalized()).map(recipe -> recipe.getRecipeResult(BrewQuality.EXCELLENT)).map(RecipeResult::displayName).orElseGet(() -> Component.text((String)this.ingredientKey.minimalized()));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BreweryIngredient that = (BreweryIngredient)o;
        return Objects.equals(this.ingredientKey, that.ingredientKey);
    }

    public int hashCode() {
        return Objects.hashCode(this.ingredientKey);
    }

    public static Optional<Ingredient> from(ItemStack itemStack) {
        PersistentDataContainerView dataContainer = itemStack.getPersistentDataContainer();
        String key = (String)dataContainer.get(BrewAdapter.BREWERY_TAG, PersistentDataType.STRING);
        if (key == null) {
            return Optional.empty();
        }
        Double score = (Double)dataContainer.get(BrewAdapter.BREWERY_SCORE, PersistentDataType.DOUBLE);
        BreweryKey breweryKey = BreweryKey.parse(key);
        BreweryIngredient baseIngredient = new BreweryIngredient(breweryKey);
        ImmutableMap.Builder extraBuilder = new ImmutableMap.Builder();
        String displayNameString = (String)dataContainer.get(BrewAdapter.BREWERY_DISPLAY_NAME, PersistentDataType.STRING);
        if (displayNameString != null) {
            Component displayName = MiniMessage.miniMessage().deserialize((Object)displayNameString);
            extraBuilder.put(IngredientMeta.DISPLAY_NAME, (Object)displayName);
        }
        if (score != null) {
            extraBuilder.put(IngredientMeta.SCORE, (Object)score);
        }
        return Optional.of(new IngredientWithMeta(baseIngredient, (Map<IngredientMeta<?>, Object>)extraBuilder.build()));
    }

    public static Optional<CompletableFuture<Optional<Ingredient>>> from(BreweryKey id) {
        if (!id.namespace().equals("brewery") && !id.namespace().equals("#brewery")) {
            return Optional.empty();
        }
        if (id.namespace().startsWith("#")) {
            return Optional.of(IngredientsSection.ingredients().getIngredient(id));
        }
        return Optional.of(new BreweryIngredient(id)).map(Optional::of).map(CompletableFuture::completedFuture);
    }
}

