/*
 * Decompiled with CFR 0.152.
 */
package dev.jsinco.brewery.bukkit.command;

import com.mojang.brigadier.arguments.DoubleArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import dev.jsinco.brewery.api.effect.DrunkState;
import dev.jsinco.brewery.api.effect.DrunksManager;
import dev.jsinco.brewery.api.effect.ModifierConsume;
import dev.jsinco.brewery.api.effect.modifier.DrunkenModifier;
import dev.jsinco.brewery.api.event.DrunkEvent;
import dev.jsinco.brewery.api.util.Pair;
import dev.jsinco.brewery.bukkit.TheBrewingProject;
import dev.jsinco.brewery.bukkit.command.BreweryCommand;
import dev.jsinco.brewery.bukkit.command.argument.FlaggedArgumentBuilder;
import dev.jsinco.brewery.bukkit.util.BukkitMessageUtil;
import dev.jsinco.brewery.configuration.DrunkenModifierSection;
import dev.jsinco.brewery.effect.DrunkStateImpl;
import dev.jsinco.brewery.effect.DrunksManagerImpl;
import dev.jsinco.brewery.format.TimeFormat;
import dev.jsinco.brewery.format.TimeFormatter;
import dev.jsinco.brewery.util.MessageUtil;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import io.papermc.paper.command.brigadier.Commands;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.minimessage.tag.resolver.Formatter;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import net.kyori.adventure.text.minimessage.translation.Argument;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.jetbrains.annotations.NotNull;

public class StatusCommand {
    private static final DynamicCommandExceptionType MISSING_ARGUMENT = new DynamicCommandExceptionType(value -> BukkitMessageUtil.toBrigadier("tbp.command.missing-argument", new TagResolver[]{Placeholder.unparsed((String)"argument_type", (String)value.toString())}));

    private static int clear(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        OfflinePlayer target = BreweryCommand.getOfflinePlayer(context);
        CommandSender sender = ((CommandSourceStack)context.getSource()).getSender();
        ((DrunksManagerImpl)TheBrewingProject.getInstance().getDrunksManager()).clear(target.getUniqueId());
        MessageUtil.message((Audience)sender, "tbp.command.status.clear.message", new TagResolver[]{Placeholder.unparsed((String)"player_name", (String)target.getName())});
        return 1;
    }

    private static int info(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        OfflinePlayer target = BreweryCommand.getOfflinePlayer(context);
        CommandSender sender = ((CommandSourceStack)context.getSource()).getSender();
        DrunksManager drunksManager = TheBrewingProject.getInstance().getDrunksManager();
        MessageUtil.message((Audience)sender, "tbp.command.status.info.message", StatusCommand.compileStatusTagResolvers(target, drunksManager, List.of()));
        return 1;
    }

    private static TagResolver[] compileStatusTagResolvers(OfflinePlayer target, DrunksManager drunksManager, List<ModifierConsume> consumes) {
        DrunkState drunkState = drunksManager.getDrunkState(target.getUniqueId());
        Pair<DrunkEvent, Long> nextEvent = drunksManager.getPlannedEvent(target.getUniqueId());
        drunksManager.getPlannedEvent(target.getUniqueId());
        String targetName = target.getName();
        if (drunkState == null) {
            drunkState = new DrunkStateImpl(TheBrewingProject.getInstance().getTime(), -1L);
        }
        TagResolver.Single consumesResolver = Placeholder.component((String)"consumed_modifiers", (ComponentLike)((ComponentLike)consumes.stream().map(consumption -> Component.translatable((String)"tbp.command.status.consumed-modifier", (ComponentLike[])new ComponentLike[]{Argument.tagResolver((TagResolver[])new TagResolver[]{Placeholder.component((String)"modifier_name", (ComponentLike)consumption.modifier().displayName()), Formatter.number((String)"modifier_value", (Number)consumption.value())})})).collect(Component.toComponent((Component)Component.text((String)", ")))));
        return new TagResolver[]{consumesResolver, Placeholder.component((String)"modifiers", (ComponentLike)StatusCommand.compileModifiersMessage(drunkState)), Placeholder.unparsed((String)"player_name", (String)(targetName == null ? "null" : targetName)), Placeholder.component((String)"next_event_time", (ComponentLike)MessageUtil.miniMessage(TimeFormatter.format(nextEvent == null ? 0L : nextEvent.second() - TheBrewingProject.getInstance().getTime(), TimeFormat.CLOCK_MECHANIC), new TagResolver[0])), Placeholder.component((String)"next_event", (ComponentLike)(nextEvent == null ? Component.translatable((String)"tbp.events.nothing-planned") : nextEvent.first().displayName()))};
    }

    private static Component compileModifiersMessage(@NotNull DrunkState drunkState) {
        return (Component)DrunkenModifierSection.modifiers().drunkenModifiers().stream().map(modifier -> Component.translatable((String)"tbp.command.status.info.modifier", (ComponentLike[])new ComponentLike[]{Argument.tagResolver((TagResolver[])new TagResolver[]{Placeholder.component((String)"modifier_name", (ComponentLike)modifier.displayName()), Formatter.number((String)"modifier_value", (Number)drunkState.modifierValue((DrunkenModifier)modifier))})})).collect(Component.toComponent((Component)Component.text((String)"\n")));
    }

    public static ArgumentBuilder<CommandSourceStack, ?> command() {
        LiteralArgumentBuilder root = Commands.literal((String)"status");
        StatusCommand.registerBranches(root);
        root.then(BreweryCommand.offlinePlayerBranch(StatusCommand::registerBranches));
        return root;
    }

    private static void registerBranches(ArgumentBuilder<CommandSourceStack, ?> root) {
        root.then(Commands.literal((String)"info").executes(StatusCommand::info));
        root.then(Commands.literal((String)"clear").executes(StatusCommand::clear));
        Set<FlaggedArgumentBuilder.Flag> consumeFlags = DrunkenModifierSection.modifiers().drunkenModifiers().stream().map(drunkenModifier -> new FlaggedArgumentBuilder.Flag(drunkenModifier.name(), null, List.of(new Pair<String, DoubleArgumentType>(drunkenModifier.name(), DoubleArgumentType.doubleArg((double)(drunkenModifier.minValue() - drunkenModifier.maxValue()), (double)(drunkenModifier.maxValue() - drunkenModifier.minValue())))), Set.of())).collect(Collectors.toSet());
        Set<FlaggedArgumentBuilder.Flag> setFlags = DrunkenModifierSection.modifiers().drunkenModifiers().stream().map(drunkenModifier -> new FlaggedArgumentBuilder.Flag(drunkenModifier.name(), null, List.of(new Pair<String, DoubleArgumentType>(drunkenModifier.name(), DoubleArgumentType.doubleArg((double)drunkenModifier.minValue(), (double)drunkenModifier.maxValue()))), Set.of())).collect(Collectors.toSet());
        LiteralArgumentBuilder consume = Commands.literal((String)"consume");
        LiteralArgumentBuilder set = Commands.literal((String)"set");
        new FlaggedArgumentBuilder(consumeFlags, StatusCommand::consume).build().forEach(arg_0 -> ((ArgumentBuilder)consume).then(arg_0));
        new FlaggedArgumentBuilder(setFlags, StatusCommand::set).build().forEach(arg_0 -> ((ArgumentBuilder)set).then(arg_0));
        root.then((ArgumentBuilder)consume);
        root.then((ArgumentBuilder)set);
    }

    private static void set(CommandContext<CommandSourceStack> context, List<FlaggedArgumentBuilder.Flag> flags) throws CommandSyntaxException {
        OfflinePlayer target = BreweryCommand.getOfflinePlayer(context);
        if (flags.isEmpty()) {
            throw MISSING_ARGUMENT.create((Object)"modifier");
        }
        DrunksManager drunksManager = TheBrewingProject.getInstance().getDrunksManager();
        DrunkState drunkState = drunksManager.getDrunkState(target.getUniqueId());
        if (drunkState == null) {
            drunkState = new DrunkStateImpl(TheBrewingProject.getInstance().getTime(), -1L);
        }
        DrunkState finalDrunkState = drunkState;
        List<ModifierConsume> consumes = flags.stream().map(flag -> {
            DrunkenModifier modifier = DrunkenModifierSection.modifiers().modifier(flag.fullName());
            return new ModifierConsume(modifier, (Double)context.getArgument(flag.fullName(), Double.class) - finalDrunkState.modifierValue(modifier));
        }).toList();
        drunksManager.consume(target.getUniqueId(), consumes);
        CommandSender sender = ((CommandSourceStack)context.getSource()).getSender();
        MessageUtil.message((Audience)sender, "tbp.command.status.set.message", StatusCommand.compileStatusTagResolvers(target, drunksManager, consumes));
    }

    private static void consume(CommandContext<CommandSourceStack> context, List<FlaggedArgumentBuilder.Flag> flags) throws CommandSyntaxException {
        OfflinePlayer target = BreweryCommand.getOfflinePlayer(context);
        DrunksManager drunksManager = TheBrewingProject.getInstance().getDrunksManager();
        if (flags.isEmpty()) {
            throw MISSING_ARGUMENT.create((Object)"modifier");
        }
        List<ModifierConsume> consumes = flags.stream().map(flag -> new ModifierConsume(DrunkenModifierSection.modifiers().modifier(flag.fullName()), (Double)context.getArgument(flag.fullName(), Double.class))).toList();
        drunksManager.consume(target.getUniqueId(), consumes);
        CommandSender sender = ((CommandSourceStack)context.getSource()).getSender();
        MessageUtil.message((Audience)sender, "tbp.command.status.consume.message", StatusCommand.compileStatusTagResolvers(target, drunksManager, consumes));
    }
}

