/*
 * Decompiled with CFR 0.152.
 */
package dev.jsinco.brewery.bukkit.command;

import com.mojang.brigadier.arguments.DoubleArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import dev.jsinco.brewery.api.brew.Brew;
import dev.jsinco.brewery.api.brew.BrewingStep;
import dev.jsinco.brewery.api.breweries.BarrelType;
import dev.jsinco.brewery.api.breweries.CauldronType;
import dev.jsinco.brewery.api.moment.PassedMoment;
import dev.jsinco.brewery.api.util.Pair;
import dev.jsinco.brewery.brew.AgeStepImpl;
import dev.jsinco.brewery.brew.BrewImpl;
import dev.jsinco.brewery.brew.CookStepImpl;
import dev.jsinco.brewery.brew.DistillStepImpl;
import dev.jsinco.brewery.brew.MixStepImpl;
import dev.jsinco.brewery.bukkit.brew.BrewAdapter;
import dev.jsinco.brewery.bukkit.command.BreweryCommand;
import dev.jsinco.brewery.bukkit.command.argument.EnumArgument;
import dev.jsinco.brewery.bukkit.command.argument.FlaggedArgumentBuilder;
import dev.jsinco.brewery.bukkit.command.argument.IngredientsArgument;
import dev.jsinco.brewery.configuration.Config;
import dev.jsinco.brewery.util.MessageUtil;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import io.papermc.paper.command.brigadier.Commands;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;

public class CreateCommand {
    public static ArgumentBuilder<CommandSourceStack, ?> command() {
        FlaggedArgumentBuilder.Flag cook = new FlaggedArgumentBuilder.Flag("cook", "c", List.of(new Pair<String, DoubleArgumentType>("cook-time", DoubleArgumentType.doubleArg((double)0.0)), new Pair<String, EnumArgument<CauldronType>>("cauldron-type", new EnumArgument<CauldronType>(CauldronType.class)), new Pair<String, IngredientsArgument>("cook-ingredients", new IngredientsArgument())), Set.of(FlaggedArgumentBuilder.FlagProperty.MANDATORY_FIRST, FlaggedArgumentBuilder.FlagProperty.ONLY_FIRST));
        FlaggedArgumentBuilder.Flag mix = new FlaggedArgumentBuilder.Flag("mix", "m", List.of(new Pair<String, DoubleArgumentType>("mix-time", DoubleArgumentType.doubleArg((double)0.0)), new Pair<String, IngredientsArgument>("mix-ingredients", new IngredientsArgument())), Set.of(FlaggedArgumentBuilder.FlagProperty.MANDATORY_FIRST, FlaggedArgumentBuilder.FlagProperty.ONLY_FIRST));
        FlaggedArgumentBuilder.Flag distill = new FlaggedArgumentBuilder.Flag("distill", "d", List.of(new Pair<String, IntegerArgumentType>("distill-runs", IntegerArgumentType.integer((int)1))), Set.of());
        FlaggedArgumentBuilder.Flag age = new FlaggedArgumentBuilder.Flag("age", "a", List.of(new Pair<String, EnumArgument<BarrelType>>("barrel-type", new EnumArgument<BarrelType>(BarrelType.class)), new Pair<String, DoubleArgumentType>("aging-years", DoubleArgumentType.doubleArg((double)0.0))), Set.of());
        List<ArgumentBuilder<CommandSourceStack, ?>> tree = new FlaggedArgumentBuilder(Set.of(cook, mix, distill, age), (context, flags) -> {
            ArrayList<BrewingStep> steps = new ArrayList<BrewingStep>();
            for (FlaggedArgumentBuilder.Flag flag : flags) {
                if (flag == cook) {
                    steps.add(CreateCommand.parseCook((CommandContext<CommandSourceStack>)context));
                    continue;
                }
                if (flag == mix) {
                    steps.add(CreateCommand.parseMix((CommandContext<CommandSourceStack>)context));
                    continue;
                }
                if (flag == distill) {
                    steps.add(CreateCommand.parseDistill((CommandContext<CommandSourceStack>)context));
                    continue;
                }
                if (flag != age) continue;
                steps.add(CreateCommand.parseAge((CommandContext<CommandSourceStack>)context));
            }
            Player target = BreweryCommand.getPlayer((CommandContext<CommandSourceStack>)context);
            ItemStack brewItem = BrewAdapter.toItem(new BrewImpl(steps), new Brew.State.Other());
            PlayerInventory inventory = target.getInventory();
            if (!inventory.addItem(new ItemStack[]{brewItem}).isEmpty()) {
                target.getWorld().dropItem(target.getLocation(), brewItem);
            }
            MessageUtil.message((Audience)((CommandSourceStack)context.getSource()).getSender(), "tbp.command.create.success", new TagResolver[]{Placeholder.component((String)"brew_name", (ComponentLike)brewItem.effectiveName())});
        }).build();
        LiteralArgumentBuilder root = Commands.literal((String)"create");
        tree.forEach(arg_0 -> ((ArgumentBuilder)root).then(arg_0));
        root.then(BreweryCommand.playerBranch(argument -> tree.forEach(arg_0 -> ((ArgumentBuilder)argument).then(arg_0))));
        return root;
    }

    private static BrewingStep parseAge(CommandContext<CommandSourceStack> context) {
        double agingYears = (Double)context.getArgument("aging-years", Double.TYPE);
        return new AgeStepImpl(new PassedMoment((long)(agingYears * (double)Config.config().barrels().agingYearTicks())), (BarrelType)context.getArgument("barrel-type", BarrelType.class));
    }

    private static BrewingStep parseDistill(CommandContext<CommandSourceStack> context) {
        return new DistillStepImpl((Integer)context.getArgument("distill-runs", Integer.TYPE));
    }

    private static BrewingStep parseMix(CommandContext<CommandSourceStack> context) {
        double mixTime = (Double)context.getArgument("mix-time", Double.TYPE);
        Map ingredients = (Map)context.getArgument("mix-ingredients", Map.class);
        return new MixStepImpl(new PassedMoment((long)(mixTime * (double)Config.config().cauldrons().cookingMinuteTicks())), ingredients);
    }

    private static BrewingStep parseCook(CommandContext<CommandSourceStack> context) {
        double cookTime = (Double)context.getArgument("cook-time", Double.TYPE);
        CauldronType cauldronType = (CauldronType)context.getArgument("cauldron-type", CauldronType.class);
        Map ingredients = (Map)context.getArgument("cook-ingredients", Map.class);
        return new CookStepImpl(new PassedMoment((long)(cookTime * (double)Config.config().cauldrons().cookingMinuteTicks())), ingredients, cauldronType);
    }
}

