/*
 * Decompiled with CFR 0.152.
 */
package dev.jsinco.brewery.bukkit.command;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import dev.jsinco.brewery.api.event.DrunkEvent;
import dev.jsinco.brewery.bukkit.TheBrewingProject;
import dev.jsinco.brewery.bukkit.command.BrewerCommand;
import dev.jsinco.brewery.bukkit.command.CreateCommand;
import dev.jsinco.brewery.bukkit.command.EncryptionCommand;
import dev.jsinco.brewery.bukkit.command.InfoCommand;
import dev.jsinco.brewery.bukkit.command.ReplicateCommand;
import dev.jsinco.brewery.bukkit.command.SealCommand;
import dev.jsinco.brewery.bukkit.command.StatusCommand;
import dev.jsinco.brewery.bukkit.command.argument.EventArgument;
import dev.jsinco.brewery.bukkit.command.argument.OfflinePlayerArgument;
import dev.jsinco.brewery.bukkit.command.argument.OfflinePlayerSelectorArgumentResolver;
import dev.jsinco.brewery.bukkit.util.BukkitMessageUtil;
import dev.jsinco.brewery.configuration.Config;
import dev.jsinco.brewery.util.MessageUtil;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import io.papermc.paper.command.brigadier.Commands;
import io.papermc.paper.command.brigadier.argument.ArgumentTypes;
import io.papermc.paper.command.brigadier.argument.resolvers.selector.PlayerSelectorArgumentResolver;
import io.papermc.paper.plugin.lifecycle.event.registrar.ReloadableRegistrarEvent;
import java.util.List;
import java.util.function.Consumer;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class BreweryCommand {
    private static final SimpleCommandExceptionType ERROR_UNDEFINED_PLAYER = new SimpleCommandExceptionType(BukkitMessageUtil.toBrigadier("tbp.command.undefined-player", new TagResolver[0]));

    public static void register(ReloadableRegistrarEvent<Commands> commands) {
        ArgumentBuilder eventCommand = Commands.argument((String)"event-type", (ArgumentType)new EventArgument()).executes(context -> {
            Player target = BreweryCommand.getPlayer((CommandContext<CommandSourceStack>)context);
            DrunkEvent event = (DrunkEvent)context.getArgument("event-type", DrunkEvent.class);
            TheBrewingProject.getInstance().getDrunkEventExecutor().doDrunkEvent(target.getUniqueId(), event);
            return 1;
        });
        ((Commands)commands.registrar()).register(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"tbp").then(CreateCommand.command().requires(commandSourceStack -> commandSourceStack.getSender().hasPermission("brewery.command.create")))).then(InfoCommand.command("info", false).requires(commandSourceStack -> commandSourceStack.getSender().hasPermission("brewery.command.info")))).then(InfoCommand.command("debug", true).requires(commandSourceStack -> commandSourceStack.getSender().hasPermission("brewery.command.debug")))).then(SealCommand.command().requires(commandSourceStack -> commandSourceStack.getSender().hasPermission("brewery.command.seal")))).then(BrewerCommand.command().requires(commandSourceStack -> commandSourceStack.getSender().hasPermission("brewery.command.brewer")))).then(StatusCommand.command().requires(commandSourceStack -> commandSourceStack.getSender().hasPermission("brewery.command.status")))).then(((LiteralArgumentBuilder)Commands.literal((String)"reload").executes(context -> {
            CommandSender sender = ((CommandSourceStack)context.getSource()).getSender();
            MessageUtil.message((Audience)sender, "tbp.command.reload-message", new TagResolver[0]);
            TheBrewingProject.getInstance().reload();
            return 1;
        })).requires(commandSourceStack -> commandSourceStack.getSender().hasPermission("brewery.command.reload")))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"event").then(eventCommand)).then(BreweryCommand.playerBranch(argument -> argument.then(eventCommand)))).requires(commandSourceStack -> commandSourceStack.getSender().hasPermission("brewery.command.event")))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"replicate").then(BreweryCommand.playerBranch(argument -> argument.then(ReplicateCommand.command())))).then(ReplicateCommand.command())).requires(commandSourceStack -> commandSourceStack.getSender().hasPermission("brewery.command.replicate")))).then(((LiteralArgumentBuilder)Commands.literal((String)"version").requires(commandSourceStack -> commandSourceStack.getSender().hasPermission("brewery.command.version"))).executes(commandContext -> {
            MessageUtil.message((Audience)((CommandSourceStack)commandContext.getSource()).getSender(), "tbp.command.version", new TagResolver[]{Placeholder.unparsed((String)"version", (String)TheBrewingProject.getInstance().getPluginMeta().getVersion())});
            return 1;
        }))).then(((LiteralArgumentBuilder)Commands.literal((String)"encryption").requires(commandSourceStack -> commandSourceStack.getSender().hasPermission("brewery.command.encryption"))).then(EncryptionCommand.command()))).build(), Config.config().commandAliases());
    }

    public static ArgumentBuilder<CommandSourceStack, ?> playerBranch(Consumer<ArgumentBuilder<CommandSourceStack, ?>> childAction) {
        RequiredArgumentBuilder child = Commands.argument((String)"player", (ArgumentType)ArgumentTypes.player());
        childAction.accept((ArgumentBuilder<CommandSourceStack, ?>)child);
        return ((LiteralArgumentBuilder)Commands.literal((String)"for").then((ArgumentBuilder)child)).requires(commandSourceStack -> commandSourceStack.getSender().hasPermission("brewery.command.other"));
    }

    public static ArgumentBuilder<CommandSourceStack, ?> offlinePlayerBranch(Consumer<ArgumentBuilder<CommandSourceStack, ?>> childAction) {
        RequiredArgumentBuilder child = Commands.argument((String)"player", (ArgumentType)OfflinePlayerArgument.SINGLE);
        childAction.accept((ArgumentBuilder<CommandSourceStack, ?>)child);
        return ((LiteralArgumentBuilder)Commands.literal((String)"for").then((ArgumentBuilder)child)).requires(commandSourceStack -> commandSourceStack.getSender().hasPermission("brewery.command.other"));
    }

    public static OfflinePlayer getOfflinePlayer(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        try {
            List<OfflinePlayer> resolved = ((OfflinePlayerSelectorArgumentResolver)context.getArgument("player", OfflinePlayerSelectorArgumentResolver.class)).resolve((CommandSourceStack)context.getSource());
            if (resolved.isEmpty()) {
                throw ERROR_UNDEFINED_PLAYER.create();
            }
            return resolved.getFirst();
        }
        catch (IllegalArgumentException resolved) {
            CommandSender commandSender = ((CommandSourceStack)context.getSource()).getSender();
            if (commandSender instanceof OfflinePlayer) {
                OfflinePlayer player = (OfflinePlayer)commandSender;
                return player;
            }
            throw ERROR_UNDEFINED_PLAYER.create();
        }
    }

    public static Player getPlayer(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        try {
            List resolved = (List)((PlayerSelectorArgumentResolver)context.getArgument("player", PlayerSelectorArgumentResolver.class)).resolve((CommandSourceStack)context.getSource());
            if (resolved.isEmpty()) {
                throw ERROR_UNDEFINED_PLAYER.create();
            }
            return (Player)resolved.getFirst();
        }
        catch (IllegalArgumentException e) {
            CommandSender commandSender = ((CommandSourceStack)context.getSource()).getSender();
            if (commandSender instanceof Player) {
                Player player = (Player)commandSender;
                return player;
            }
            throw ERROR_UNDEFINED_PLAYER.create();
        }
    }
}

