/*
 * Decompiled with CFR 0.152.
 */
package dev.jsinco.brewery.bukkit.breweries.distillery;

import dev.jsinco.brewery.api.brew.Brew;
import dev.jsinco.brewery.api.util.Logger;
import dev.jsinco.brewery.api.util.Pair;
import dev.jsinco.brewery.api.vector.BreweryLocation;
import dev.jsinco.brewery.bukkit.TheBrewingProject;
import dev.jsinco.brewery.bukkit.brew.BukkitDistilleryBrewDataType;
import dev.jsinco.brewery.bukkit.breweries.BrewInventoryImpl;
import dev.jsinco.brewery.bukkit.breweries.BrewPersistenceHandler;
import dev.jsinco.brewery.database.PersistenceException;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DistilleryBrewPersistenceHandler
implements BrewPersistenceHandler {
    private final BreweryLocation unique;
    private final boolean distillate;

    public DistilleryBrewPersistenceHandler(BreweryLocation unique, boolean distillate) {
        this.unique = unique;
        this.distillate = distillate;
    }

    @Override
    public void store(@Nullable Brew brew, int position, @NotNull BrewInventoryImpl inventory) {
        if (Objects.equals(inventory.getBrews()[position], brew)) {
            return;
        }
        try {
            Brew previous = inventory.getBrews()[position];
            BukkitDistilleryBrewDataType.DistilleryContext context = this.contextProvider(position);
            Pair<Brew, BukkitDistilleryBrewDataType.DistilleryContext> data = new Pair<Brew, BukkitDistilleryBrewDataType.DistilleryContext>(brew, context);
            if (previous == null) {
                TheBrewingProject.getInstance().getDatabase().insertValue(BukkitDistilleryBrewDataType.INSTANCE, data);
                return;
            }
            if (brew == null) {
                TheBrewingProject.getInstance().getDatabase().remove(BukkitDistilleryBrewDataType.INSTANCE, data);
                return;
            }
            TheBrewingProject.getInstance().getDatabase().updateValue(BukkitDistilleryBrewDataType.INSTANCE, data);
        }
        catch (PersistenceException e) {
            Logger.logErr(e);
        }
    }

    private BukkitDistilleryBrewDataType.DistilleryContext contextProvider(int position) {
        return new BukkitDistilleryBrewDataType.DistilleryContext(this.unique.x(), this.unique.y(), this.unique.z(), this.unique.worldUuid(), position, this.distillate);
    }
}

