/*
 * Decompiled with CFR 0.152.
 */
package dev.jsinco.brewery.bukkit.breweries.barrel;

import dev.jsinco.brewery.api.brew.Brew;
import dev.jsinco.brewery.api.util.Logger;
import dev.jsinco.brewery.api.util.Pair;
import dev.jsinco.brewery.api.vector.BreweryLocation;
import dev.jsinco.brewery.brew.BarrelBrewDataType;
import dev.jsinco.brewery.bukkit.TheBrewingProject;
import dev.jsinco.brewery.bukkit.brew.BukkitBarrelBrewDataType;
import dev.jsinco.brewery.bukkit.breweries.BrewInventoryImpl;
import dev.jsinco.brewery.bukkit.breweries.BrewPersistenceHandler;
import dev.jsinco.brewery.database.PersistenceException;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BarrelBrewPersistenceHandler
implements BrewPersistenceHandler {
    private final BreweryLocation unique;

    public BarrelBrewPersistenceHandler(BreweryLocation unique) {
        this.unique = unique;
    }

    @Override
    public void store(@Nullable Brew brew, int position, @NotNull BrewInventoryImpl inventory) {
        if (Objects.equals(inventory.getBrews()[position], brew)) {
            return;
        }
        try {
            Brew previous = inventory.getBrews()[position];
            BarrelBrewDataType.BarrelContext context = new BarrelBrewDataType.BarrelContext(this.unique.x(), this.unique.y(), this.unique.z(), position, this.unique.worldUuid());
            Pair<Brew, BarrelBrewDataType.BarrelContext> data = new Pair<Brew, BarrelBrewDataType.BarrelContext>(brew, context);
            if (previous == null) {
                TheBrewingProject.getInstance().getDatabase().insertValue(BukkitBarrelBrewDataType.INSTANCE, data);
                return;
            }
            if (brew == null) {
                TheBrewingProject.getInstance().getDatabase().remove(BukkitBarrelBrewDataType.INSTANCE, data);
                return;
            }
            TheBrewingProject.getInstance().getDatabase().updateValue(BukkitBarrelBrewDataType.INSTANCE, data);
        }
        catch (PersistenceException e) {
            Logger.logErr(e);
        }
    }
}

