/*
 * Decompiled with CFR 0.152.
 */
package dev.jsinco.brewery.bukkit.api.transaction;

import com.google.common.base.Preconditions;
import dev.jsinco.brewery.bukkit.api.transaction.ItemSource;
import dev.jsinco.brewery.bukkit.api.transaction.ItemTransaction;
import lombok.Generated;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.Nullable;

public class ItemTransactionSession<T extends ItemSource> {
    private ItemTransaction transaction;
    @Nullable
    private T result;

    public ItemTransactionSession(ItemTransaction transaction, @Nullable T result) {
        this.transaction = (ItemTransaction)Preconditions.checkNotNull((Object)transaction);
        this.setResult(result);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setResult(@Nullable T result) {
        if (!(result instanceof ItemSource.ItemBasedSource)) {
            this.result = result;
            return;
        }
        ItemSource.ItemBasedSource itemBasedSource = (ItemSource.ItemBasedSource)result;
        try {
            ItemStack itemStack;
            ItemStack itemStack2 = itemStack = itemBasedSource.itemStack();
            this.result = new ItemSource.ItemBasedSource(itemStack2.clone());
            return;
        }
        catch (Throwable throwable) {
            throw new MatchException(throwable.toString(), throwable);
        }
    }

    @Generated
    public ItemTransaction getTransaction() {
        return this.transaction;
    }

    @Nullable
    @Generated
    public T getResult() {
        return this.result;
    }
}

