/*
 * Decompiled with CFR 0.152.
 */
package dev.jsinco.brewery.bukkit.api.ingredient;

import dev.jsinco.brewery.api.ingredient.BaseIngredient;
import dev.jsinco.brewery.api.util.BreweryKey;
import dev.jsinco.brewery.bukkit.api.integration.ItemIntegration;
import java.util.Objects;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.Style;
import org.jetbrains.annotations.NotNull;

public class PluginIngredient
implements BaseIngredient {
    private final ItemIntegration itemIntegration;
    private final BreweryKey key;

    public PluginIngredient(BreweryKey key, ItemIntegration itemIntegration) {
        this.key = key;
        this.itemIntegration = itemIntegration;
    }

    @Override
    @NotNull
    public String getKey() {
        return this.key.toString();
    }

    @Override
    @NotNull
    public Component displayName() {
        Component displayName = this.itemIntegration.displayName(this.key.key());
        return displayName == null ? Component.text((String)this.key.key()) : displayName.style(Style.empty());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PluginIngredient that = (PluginIngredient)o;
        return Objects.equals(that.key, this.key) && this.itemIntegration == that.itemIntegration;
    }

    public int hashCode() {
        return Objects.hashCode(this.key);
    }
}

