/*
 * Decompiled with CFR 0.152.
 */
package dev.jsinco.brewery.brew;

import dev.jsinco.brewery.api.brew.BrewingStep;
import dev.jsinco.brewery.api.brew.PartialBrewScore;
import dev.jsinco.brewery.api.brew.ScoreType;
import dev.jsinco.brewery.api.breweries.CauldronType;
import dev.jsinco.brewery.api.ingredient.Ingredient;
import dev.jsinco.brewery.api.moment.Moment;
import dev.jsinco.brewery.brew.BrewingStepUtil;
import dev.jsinco.brewery.util.CollectionUtil;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.SequencedCollection;
import java.util.SequencedSet;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public record CookStepImpl(Moment time, Map<? extends Ingredient, Integer> ingredients, CauldronType cauldronType, SequencedSet<UUID> brewers) implements BrewingStep.Cook
{
    private static final Map<ScoreType, PartialBrewScore> BREW_STEP_MISMATCH = Stream.of(new PartialBrewScore(0.0, ScoreType.TIME), new PartialBrewScore(0.0, ScoreType.INGREDIENTS)).collect(Collectors.toUnmodifiableMap(PartialBrewScore::type, partial -> partial));

    public CookStepImpl(Moment time, Map<? extends Ingredient, Integer> ingredients, CauldronType cauldronType) {
        this(time, ingredients, cauldronType, Collections.emptySortedSet());
    }

    @Override
    public CookStepImpl withBrewTime(Moment brewTime) {
        return new CookStepImpl(brewTime, this.ingredients, this.cauldronType, this.brewers);
    }

    @Override
    public CookStepImpl withIngredients(Map<? extends Ingredient, Integer> ingredients) {
        return new CookStepImpl(this.time, ingredients, this.cauldronType, this.brewers);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Map<ScoreType, PartialBrewScore> proximityScores(BrewingStep other) {
        Moment otherTime;
        SequencedSet<UUID> sequencedSet;
        if (!(other instanceof CookStepImpl)) return BREW_STEP_MISMATCH;
        CookStepImpl cookStepImpl = (CookStepImpl)other;
        try {
            sequencedSet = cookStepImpl.time();
            otherTime = sequencedSet;
        }
        catch (Throwable throwable) {
            throw new MatchException(throwable.toString(), throwable);
        }
        SequencedSet<UUID> otherIngredients = sequencedSet = cookStepImpl.ingredients();
        SequencedSet<UUID> otherType = sequencedSet = cookStepImpl.cauldronType();
        SequencedSet<UUID> ignored = sequencedSet = cookStepImpl.brewers();
        double cauldronTypeScore = this.cauldronType.equals(otherType) ? 1.0 : 0.0;
        double timeScore = Math.sqrt(BrewingStepUtil.nearbyValueScore(this.time.moment(), otherTime.moment()));
        double ingredientsScore = BrewingStepUtil.getIngredientsScore(this.ingredients, otherIngredients);
        return Stream.of(new PartialBrewScore(cauldronTypeScore * timeScore, ScoreType.TIME), new PartialBrewScore(ingredientsScore, ScoreType.INGREDIENTS)).collect(Collectors.toUnmodifiableMap(PartialBrewScore::type, partial -> partial));
    }

    @Override
    public BrewingStep.StepType stepType() {
        return BrewingStep.StepType.COOK;
    }

    @Override
    public Map<ScoreType, PartialBrewScore> maximumScores(BrewingStep other) {
        return this.proximityScores(other);
    }

    @Override
    public Map<ScoreType, PartialBrewScore> failedScores() {
        return BREW_STEP_MISMATCH;
    }

    @Override
    public boolean isCompleted() {
        return true;
    }

    @Override
    public BrewingStep.Cook withBrewersReplaced(SequencedCollection<UUID> brewers) {
        return new CookStepImpl(this.time, this.ingredients, this.cauldronType, new LinkedHashSet<UUID>(brewers));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object o) {
        Moment otherTime;
        SequencedSet<UUID> sequencedSet;
        if (!(o instanceof CookStepImpl)) return false;
        CookStepImpl cookStepImpl = (CookStepImpl)o;
        try {
            sequencedSet = cookStepImpl.time();
            otherTime = sequencedSet;
        }
        catch (Throwable throwable) {
            throw new MatchException(throwable.toString(), throwable);
        }
        SequencedSet<UUID> otherIngredients = sequencedSet = cookStepImpl.ingredients();
        SequencedSet<UUID> otherType = sequencedSet = cookStepImpl.cauldronType();
        SequencedSet<UUID> otherBrewers = sequencedSet = cookStepImpl.brewers();
        if (!Objects.equals(this.time, otherTime)) return false;
        if (!Objects.equals(this.ingredients, otherIngredients)) return false;
        if (this.cauldronType != otherType) return false;
        if (!CollectionUtil.isEqualWithOrdering(this.brewers, otherBrewers)) return false;
        return true;
    }
}

