/*
 * Decompiled with CFR 0.152.
 */
package dev.jsinco.brewery.brew;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import dev.jsinco.brewery.api.brew.BrewingStep;
import dev.jsinco.brewery.api.breweries.BarrelType;
import dev.jsinco.brewery.api.breweries.CauldronType;
import dev.jsinco.brewery.api.ingredient.Ingredient;
import dev.jsinco.brewery.api.ingredient.IngredientManager;
import dev.jsinco.brewery.api.moment.Moment;
import dev.jsinco.brewery.api.util.BreweryKey;
import dev.jsinco.brewery.api.util.BreweryRegistry;
import dev.jsinco.brewery.brew.AgeStepImpl;
import dev.jsinco.brewery.brew.CookStepImpl;
import dev.jsinco.brewery.brew.DistillStepImpl;
import dev.jsinco.brewery.brew.MixStepImpl;
import dev.jsinco.brewery.ingredient.IngredientUtil;
import java.lang.runtime.SwitchBootstraps;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.SequencedSet;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;

public class BrewingStepSerializer {
    public static final BrewingStepSerializer INSTANCE = new BrewingStepSerializer();

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public JsonObject serialize(BrewingStep step, IngredientManager<?> ingredientManager) {
        JsonObject object = new JsonObject();
        object.addProperty("type", step.stepType().name().toLowerCase(Locale.ROOT));
        BrewingStep brewingStep = step;
        Objects.requireNonNull(brewingStep);
        BrewingStep brewingStep2 = brewingStep;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{AgeStepImpl.class, CookStepImpl.class, DistillStepImpl.class, MixStepImpl.class}, (Object)brewingStep2, n)) {
            case 0: {
                SequencedSet<UUID> brewers;
                AgeStepImpl ageStepImpl = (AgeStepImpl)brewingStep2;
                try {
                    SequencedSet<UUID> sequencedSet = ageStepImpl.time();
                    Moment age = sequencedSet;
                    SequencedSet<UUID> type = sequencedSet = ageStepImpl.barrelType();
                    brewers = sequencedSet = ageStepImpl.brewers();
                    object.add("age", Moment.SERIALIZER.serialize(age));
                    object.addProperty("barrel_type", ((BarrelType)((Object)type)).key().toString());
                }
                catch (Throwable throwable) {
                    throw new MatchException(throwable.toString(), throwable);
                }
                if (brewers.isEmpty()) return object;
                object.add("brewers", BrewingStepSerializer.brewersToJson(brewers));
                return object;
            }
            case 1: {
                SequencedSet<UUID> brewers;
                CookStepImpl cookStepImpl = (CookStepImpl)brewingStep2;
                {
                    SequencedSet<UUID> sequencedSet = cookStepImpl.time();
                    Moment brewTime = sequencedSet;
                    SequencedSet<UUID> ingredients = sequencedSet = cookStepImpl.ingredients();
                    SequencedSet<UUID> cauldronType = sequencedSet = cookStepImpl.cauldronType();
                    brewers = sequencedSet = cookStepImpl.brewers();
                    object.add("brew_time", Moment.SERIALIZER.serialize(brewTime));
                    object.addProperty("cauldron_type", ((CauldronType)((Object)cauldronType)).key().toString());
                    object.add("ingredients", IngredientUtil.ingredientsToJson(ingredients, ingredientManager));
                }
                if (brewers.isEmpty()) return object;
                object.add("brewers", BrewingStepSerializer.brewersToJson(brewers));
                return object;
            }
            case 2: {
                SequencedSet<UUID> brewers;
                DistillStepImpl distillStepImpl = (DistillStepImpl)brewingStep2;
                {
                    SequencedSet<UUID> sequencedSet;
                    int n2;
                    int runs = n2 = distillStepImpl.runs();
                    brewers = sequencedSet = distillStepImpl.brewers();
                    object.addProperty("runs", runs);
                }
                if (brewers.isEmpty()) return object;
                object.add("brewers", BrewingStepSerializer.brewersToJson(brewers));
                return object;
            }
            case 3: {
                SequencedSet<UUID> brewers;
                MixStepImpl mixStepImpl = (MixStepImpl)brewingStep2;
                {
                    SequencedSet<UUID> sequencedSet = mixStepImpl.time();
                    Moment time = sequencedSet;
                    SequencedSet<UUID> ingredients = sequencedSet = mixStepImpl.ingredients();
                    brewers = sequencedSet = mixStepImpl.brewers();
                    object.add("ingredients", IngredientUtil.ingredientsToJson(ingredients, ingredientManager));
                    object.add("mix_time", Moment.SERIALIZER.serialize(time));
                }
                if (brewers.isEmpty()) return object;
                object.add("brewers", BrewingStepSerializer.brewersToJson(brewers));
                return object;
            }
        }
        throw new IllegalStateException("Unexpected value: " + String.valueOf(step));
    }

    private static JsonArray brewersToJson(SequencedSet<UUID> brewers) {
        JsonArray arr = new JsonArray();
        for (UUID brewer : brewers) {
            arr.add(brewer.toString());
        }
        return arr;
    }

    public CompletableFuture<BrewingStep> deserialize(JsonElement jsonElement, IngredientManager<?> ingredientManager) {
        JsonObject object = jsonElement.getAsJsonObject();
        BrewingStep.StepType stepType = BrewingStep.StepType.valueOf(object.get("type").getAsString().toUpperCase(Locale.ROOT));
        return switch (stepType) {
            default -> throw new MatchException(null, null);
            case BrewingStep.StepType.COOK -> IngredientUtil.ingredientsFromJson(object.get("ingredients").getAsJsonObject(), ingredientManager).thenApplyAsync(ingredients -> new CookStepImpl(Moment.SERIALIZER.deserialize(object.get("brew_time")), (Map<? extends Ingredient, Integer>)ingredients, BreweryRegistry.CAULDRON_TYPE.get(BreweryKey.parse(object.get("cauldron_type").getAsString())), BrewingStepSerializer.jsonToBrewers(object)));
            case BrewingStep.StepType.DISTILL -> CompletableFuture.completedFuture(new DistillStepImpl(object.get("runs").getAsInt(), BrewingStepSerializer.jsonToBrewers(object)));
            case BrewingStep.StepType.AGE -> CompletableFuture.completedFuture(new AgeStepImpl(Moment.SERIALIZER.deserialize(object.get("age")), BreweryRegistry.BARREL_TYPE.get(BreweryKey.parse(object.get("barrel_type").getAsString())), BrewingStepSerializer.jsonToBrewers(object)));
            case BrewingStep.StepType.MIX -> IngredientUtil.ingredientsFromJson(object.get("ingredients").getAsJsonObject(), ingredientManager).thenApplyAsync(ingredients -> new MixStepImpl(Moment.SERIALIZER.deserialize(object.get("mix_time")), (Map<? extends Ingredient, Integer>)ingredients, BrewingStepSerializer.jsonToBrewers(object)));
        };
    }

    private static SequencedSet<UUID> jsonToBrewers(JsonObject obj) {
        if (!obj.has("brewers")) {
            return Collections.emptySortedSet();
        }
        LinkedHashSet<UUID> brewers = new LinkedHashSet<UUID>();
        for (JsonElement element : obj.get("brewers").getAsJsonArray()) {
            UUID brewer = UUID.fromString(element.getAsString());
            brewers.add(brewer);
        }
        return brewers;
    }
}

