/*
 * Decompiled with CFR 0.152.
 */
package dev.jsinco.brewery.api.moment;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import dev.jsinco.brewery.api.moment.Interval;
import dev.jsinco.brewery.api.moment.PassedMoment;
import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;

public sealed interface Moment
permits Interval, PassedMoment {
    public static final int SECOND = 20;
    public static final int MINUTE = 1200;
    public static final int DEFAULT_AGING_YEAR = 24000;
    public static final Serializer SERIALIZER = new Serializer();

    public long moment();

    public Interval withLastStep(long var1);

    public Interval withMovedEnding(long var1);

    public static class Serializer {
        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public JsonElement serialize(Moment moment) {
            JsonElement jsonElement;
            Moment moment2 = moment;
            Objects.requireNonNull(moment2);
            Moment moment3 = moment2;
            int n = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Interval.class, PassedMoment.class}, (Object)moment3, n)) {
                default: {
                    throw new MatchException(null, null);
                }
                case 0: {
                    Interval interval = (Interval)moment3;
                    try {
                        long l;
                        long start = l = interval.start();
                        long end = l = interval.stop();
                        JsonArray array = new JsonArray();
                        array.add(new JsonPrimitive(start));
                        array.add(new JsonPrimitive(end));
                        jsonElement = array;
                        return jsonElement;
                    }
                    catch (Throwable throwable) {
                        throw new MatchException(throwable.toString(), throwable);
                    }
                }
                case 1: 
            }
            PassedMoment passedMoment = (PassedMoment)moment3;
            {
                long l;
                long time = l = passedMoment.moment();
                jsonElement = new JsonPrimitive(time);
            }
            return jsonElement;
        }

        public Moment deserialize(JsonElement json) {
            if (json instanceof JsonPrimitive) {
                JsonPrimitive primitive = (JsonPrimitive)json;
                return new PassedMoment(primitive.getAsLong());
            }
            JsonArray array = json.getAsJsonArray();
            return new Interval(array.get(0).getAsLong(), array.get(1).getAsLong());
        }
    }
}

